/*
 * $Id$
 */

package csbase.client.applications.commandviewer;

import javax.swing.SwingUtilities;

import csbase.client.algorithms.commands.newview.CommandViewFactory;
import csbase.client.algorithms.commands.newview.NewCommandViewUtils;
import csbase.client.algorithms.commands.tasks.GetCommandTask;
import csbase.client.algorithms.commands.view.TabType;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommandInfo;
import csbase.logic.CommonClientProject;

/**
 * Aplicao de visualizao de um comando.
 *
 * @author Tecgraf / PUC-Rio
 */
public class CommandViewer extends ApplicationType {

  /**
   * Nome da mensagem que pode ser enviada  aplicao para forar a abertura de
   * um comando especfico.
   */
  private static final String OPEN_COMMAND_MSG = "OPEN_COMMAND";

  /**
   * Construtor.
   *
   * @param id identificador nico da aplicao.
   */
  public CommandViewer(String id) {
    super(id);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void killApplication()  {
    ApplicationManager manager = ApplicationManager.getInstance();
    manager.notifyDeath(this);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean userCanKillApplication() {
    return true;
  }

  @Override
  public void startApplication() throws ApplicationException {
    // No faz nada pois a janela  aberta somente quando  recebida uma mensagem
    // com o identificador do comando a ser visualizado.
  }

  @Override
  public void finishApplication() {
    // No faz nada.
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void sendMessage(String name, Object value, String senderId) {
    if (name == null) {
      throw new IllegalArgumentException("O parmetro name no pode ser nulo.");
    }
    if (value == null) {
      throw new IllegalArgumentException("O parmetro value no pode ser nulo.");
    }
    if (name.equals(OPEN_COMMAND_MSG) && (value instanceof String)) {
      showCommand((String) value);
    }
    killApplication();
  }

  /**
   * Mostra a janela de parmetros d comando especificado.
   *
   * @param commandId o identificador do comando.
   */
  private void showCommand(final String commandId) {
    final DesktopFrame desktopFrame = DesktopFrame.getInstance();
    final DesktopComponentFrame frame = desktopFrame.getDesktopFrame();
    CommonClientProject project = desktopFrame.getProject();
    final CommandInfo command =
      GetCommandTask.executeTask(commandId, project.getId(), null);
    if (command != null) {
      Runnable runnable = new Runnable() {
        @Override
        public void run() {
          try {
            CommandViewFactory.showCommandView(command, frame,
              NewCommandViewUtils.getNewTabType(TabType.PARAMETERS));
          }
          catch (Exception e) {
            StandardErrorDialogs.showErrorDialog(frame, getName(), e);
          }
        }
      };
      if (SwingUtilities.isEventDispatchThread()) {
        runnable.run();
      }
      else {
        SwingUtilities.invokeLater(runnable);
      }
    }
  }
}
