package csbase.client.applications.fileexchanger.actions;

import java.util.ArrayList;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.actions.core.FileExchangerAction;
import csbase.client.applications.fileexchanger.logic.Exchange;
import csbase.client.applications.fileexchanger.logic.ExchangeState;
import csbase.client.util.StandardErrorDialogs;

/**
 * @author Tecgraf/PUC-Rio
 */
public class ShowErrorAction extends FileExchangerAction {

  /**
   * Construtor.
   * 
   * @param fileExchanger aplicao.
   */
  public ShowErrorAction(FileExchanger fileExchanger) {
    super(fileExchanger);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() {
    final FileExchanger fileExchanger = getApplication();
    final ApplicationFrame frame = fileExchanger.getApplicationFrame();
    final ArrayList<Exchange> sels = fileExchanger.getSelectedExchangeList();
    if (sels.size() == 0) {
      final String title = getClassString("title");
      final String err = getClassString("no.selection.error");
      StandardDialogs.showErrorDialog(frame, title, err);
      return;
    }

    int nsels = 0;
    for (Exchange sel : sels) {
      if (sel.getState() == ExchangeState.ERROR) {
        nsels++;
        final Exception exception = sel.getException();
        final String title = sel.toString();
        StandardErrorDialogs.showExceptionDialog(frame, title, exception);
      }
    }
    if (nsels == 0) {
      final String title = getClassString("title");
      final String err = getClassString("no.selection.has.exception.error");
      StandardDialogs.showErrorDialog(frame, title, err);
    }
  }
}
