package csbase.client.applications.projectsmanager.proxy;

import java.util.List;
import java.util.Set;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.User;
import csbase.logic.UserOutline;

/**
 * Task que obtm lista de usurios a partir de conjunto de ids (se o conjunto
 * for nulo, todos os usurios do sistema sero obtidos).
 * 
 * @author jnlopes
 * 
 */
public class RetrieveUsersTask extends ProjectsManagerTask<List<UserOutline>> {

  /**
   * Ids dos usurios que sero obtidos (nulo caso sejam todos).
   */
  final private Set<Object> userIds;

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   */
  public RetrieveUsersTask(final ProjectsManager projectsManager) {
    super(projectsManager);
    this.userIds = null;
  }

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   * @param userIds Ids dos usurios que sero obtidos.
   */
  public RetrieveUsersTask(final ProjectsManager projectsManager,
    final Set<Object> userIds) {
    super(projectsManager);
    this.userIds = userIds;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {

    final List<UserOutline> allUsers;
    if (userIds == null) {
      allUsers = User.getAllOutlines();
    }
    else {
      allUsers = User.getOutlines(userIds.toArray());
    }
    setResult(allUsers);
  }

}
