package csbase.client.applications.projectsynchronization;

import java.awt.CardLayout;
import java.awt.GridLayout;

import javax.swing.JPanel;

import tecgraf.javautils.gui.selector.ContainerSelection;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import csbase.logic.ProjectSynchronizationFileInfo;
import csbase.logic.applicationservice.ApplicationRegistry;

public class ContainerSelectionFiles {
  private JPanel rootPanel;
  private JPanel projectsPanel;
  private ContainerSelection<ProjectSynchronizationFileInfo> containerSelection;
  private ApplicationRegistry registry;

  ContainerSelectionFiles(ApplicationRegistry registry) {
    this.registry = registry;
  }

  public JPanel getRootPanel() {
    if (rootPanel == null) {
      rootPanel = new JPanel();
      CardLayout cardLayout = new CardLayout();
      cardLayout.setHgap(3);
      cardLayout.setVgap(3);
      rootPanel.setLayout(cardLayout);
      rootPanel.add("projectsPanel", getProjectsPanel());
    }
    return rootPanel;
  }

  private JPanel getProjectsPanel() {
    if (projectsPanel == null) {
      projectsPanel = new JPanel(new GridLayout(1, 1));
      projectsPanel.add(getContainerSelection().getPanel());
    }
    return projectsPanel;
  }

  public ContainerSelection<ProjectSynchronizationFileInfo> getContainerSelection() {
    if (containerSelection == null) {
      String origem = registry.getString("files");
      String destino = registry.getString("selectedFiles");
      containerSelection =
        new ContainerSelection<ProjectSynchronizationFileInfo>(
          new TableProvider(), new TableProvider(), true, true, origem, destino);
      containerSelection.adjustTableColumns();
    }
    return containerSelection;
  }

  public class TableProvider extends DefaultObjectTableProvider {
    /**
     * {@inheritDoc}
     */
    public String[] getColumnNames() {
      return new String[] { registry.getString("file"),
          registry.getString("new") };
    }

    /**
     * {@inheritDoc}
     */
    public Class<?>[] getColumnClasses() {
      return new Class[] { String.class, String.class };
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Object[] getCellValues(Object arg) {
      ProjectSynchronizationFileInfo psfi =
        (ProjectSynchronizationFileInfo) arg;
      String str;
      if (psfi.isNewFile()) {
        str = registry.getString("yes");
      }
      else {
        str = registry.getString("no");
      }
      return new String[] { psfi.generateAbsoluteFilename(), str };
    }
  }
}
