package csbase.client.applications.projectsynchronization;

import csbase.logic.ProjectSynchronizationData;
import csbase.logic.applicationservice.ApplicationRegistry;

import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.WizardException;

import java.text.MessageFormat;

import java.util.List;

public class StepSelectionFilesB extends StepSelectionFiles {
  private ProjectSynchronizationData data;

  StepSelectionFilesB(ApplicationRegistry registry) {
    super(registry);
  }

  protected void enter(History history)
  throws WizardException {
    super.enter(history);
    data = (ProjectSynchronizationData)history.get(null, "data");
    List selectedItems = (List)history.get(null, "selectedItems");
    completeContainerSelection(data.getUnitB().getFiles(), selectedItems);
  }

  protected String getInstruction() {
    return MessageFormat.format(
      registry.getString("instruction.step4"),
      new Object[] { projectNameB, serverNameB, projectNameA, serverNameA });
  }

  protected Class getNext(History arg0) {
    return StepConclusion.class;
  }

  protected String getTitle() {
    return MessageFormat.format(
      registry.getString("title.step4"),
      new Object[] { projectNameB, serverNameB });
  }

  protected void exit(History arg0) {
    confirmSelection(data.getUnitB().getFiles());
  }
}
