package csbase.client.util;

import java.applet.Applet;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Applet que verifica a verso da especificao da JVM. So necessrios 2 URL:
 * a primeira caso a verso da JVM seja compatvel com a verso requisitada, e
 * a segunda para o caso contrrio.
 */
public final class JREVersionCheck extends Applet {
  private static final String MINIMUM_VERSION = "1.1";
  private final String JRE_VERSION = "jre_version";
  private final String ERROR_PAGE = "error_page";
  private final String DESTINATION_PAGE = "destination_page";

  /** Verso da especificao da JVM. */
  private String jreVersion;

  public void init() {
    jreVersion = System.getProperty("java.version");
    System.out.println("User JVM Version: "+jreVersion);
  }

  public void start() {
    String requiredVersion = getParameter(JRE_VERSION);
    if (requiredVersion == null) {
      requiredVersion = MINIMUM_VERSION;
    }
    System.out.println("Required JVM Version: "+requiredVersion);
    URL errorPage = null;
    URL destinationPage = null;
    try {
      destinationPage = new URL(getParameter(DESTINATION_PAGE));
      errorPage = new URL(getParameter(ERROR_PAGE));
    }
    catch (MalformedURLException e) {
      e.printStackTrace();
    }
    if (jreVersion.compareTo(requiredVersion) < 0) {
      getAppletContext().showDocument(errorPage);
    }
    else {
      getAppletContext().showDocument(destinationPage);
    }
  }
}
