package csbase.client.util.csvpanel.columns;

import java.awt.Window;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.desktop.RemoteTask;
import csbase.client.desktop.Task;
import csbase.logic.ClientFile;

/**
 * Gerador de valores a partir da listagem de arquivos de um determinado
 * diretrio.
 */
public class DirectoryListingColumnGenerator implements ColumnGenerator<String> {

  /**
   * Os arquivos filhos do diretrio.
   */
  private ClientFile[] files;

  /**
   * Construtor.
   * 
   * @param owner a janela dona do gerador.
   * @param directory o diretrio a ser listado.
   */
  public DirectoryListingColumnGenerator(Window owner, ClientFile directory) {
    this.files = getChildren(owner, directory);
  }

  /**
   * 
   * Obtm o conjunto de arquivos filhos do diretrio ou nulo, caso no seja
   * possvel listar o diretrio.
   * 
   * @param owner a janela dona do gerador.
   * @param directory o diretrio a ser listado.
   * 
   * @return a lista de arquivos filhos do diretrio.
   */
  private ClientFile[] getChildren(Window owner, final ClientFile directory) {
    Task<ClientFile[]> task = new RemoteTask<ClientFile[]>() {
      @Override
      protected void performTask() throws Exception {
        setResult(directory.getChildren());
      }
    };
    String lngPrefix = DirectoryListingColumnGenerator.class.getName();
    String title = LNG.get(lngPrefix + ".task.title");
    String message =
      LNG.get(lngPrefix + ".task.message", new Object[] { directory });
    String error =
      LNG.get(lngPrefix + ".task.error", new Object[] { directory });
    if (!task.execute(owner, title, message)) {
      StandardDialogs.showErrorDialog(owner, title, error);
    }
    return task.getResult();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getValueAt(int rowIndex) {
    if (files != null && rowIndex < files.length) {
      return files[rowIndex].getStringPath();
    }
    else {
      return null;
    }
  }

}
