/*
 * DiskSpacePanel.java
 * 
 * @version $Revision$
 */
package csbase.client.applications.diskinfo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.text.NumberFormat;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.util.Rotation;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.Application;
import csbase.client.remote.srvproxies.DiskUsageProxy;
import csbase.logic.diskusageservice.DiskOccupation;

/**
 * A classe <code>DiskSpacePanel</code> modela o painel de monitorao de uso de
 * disco pelos usurios.
 * 
 * @author Andr Luiz Clinio
 */
public class DiskSpacePanel extends DiskInfoPanel {

  /** Painel que contm o grfico */
  final private JFreeChart graph;

  /**
   * {@inheritDoc}
   */
  @Override
  final public void rotatePie() {
    final PiePlot pieplot = (PiePlot) graph.getPlot();
    double angle = pieplot.getStartAngle() + 1;
    pieplot.setStartAngle(angle);
    if (angle == 360) {
      angle = 0;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public void refreshPie(final Application app) {
    final DiskOccupation occupation = DiskUsageProxy.getProjectOccupation();
    double free = occupation.getFreeSpaceMb();
    double used = occupation.getUsedSpaceMb();
    final PiePlot pieplot = (PiePlot) graph.getPlot();
    if ((free < 0) || (used < 0)) {
      used = 0;
      free = 0;
    }
    pieplot.setNoDataMessage(app
      .getString("DiskSpacePanel.get.usage.failed.error"));
    final String freeStr = app.getString("panel.space.legend.free");
    final String usedStr = app.getString("panel.space.legend.used");
    final String labelFmt = app.getString("panel.space.label.format");
    final String legendFmt = app.getString("panel.space.legend.format");
    final NumberFormat sizeFormatter =
      NumberFormat.getNumberInstance(LNG.getLocale());
    sizeFormatter.setMinimumFractionDigits(2);
    sizeFormatter.setMaximumFractionDigits(2);
    final NumberFormat percFormatter = NumberFormat.getPercentInstance();
    final DefaultPieDataset dataset = new DefaultPieDataset();
    dataset.setValue(freeStr, free);
    dataset.setValue(usedStr, used);
    pieplot.setLabelGenerator(new StandardPieSectionLabelGenerator(labelFmt,
      sizeFormatter, percFormatter));
    pieplot.setLegendLabelGenerator(new StandardPieSectionLabelGenerator(
      legendFmt));
    pieplot.setSectionPaint("0", Color.green.darker());
    pieplot.setSectionPaint("1", Color.red.darker());
    pieplot.setDirection(Rotation.CLOCKWISE);
    pieplot.setForegroundAlpha(0.7F);
    pieplot.setBackgroundPaint(null);
    pieplot.setOutlinePaint(null);
    pieplot.setCircular(true);
    pieplot.setDataset(dataset);
  }

  /**
   * Construtor do painel DiskSpacePanel.
   * 
   * @param app referncia para a aplicao que iniciou o painel
   */
  public DiskSpacePanel(final Application app) {
    final String name = app.getString("panel.space.disk");
    final String tabName = app.getString("panel.space.disk.tab");
    graph = ChartFactory.createPieChart3D(name, null, true, false, false);
    final ChartPanel chartPanel = new ChartPanel(graph);
    chartPanel.setPopupMenu(null);
    this.setLayout(new BorderLayout());
    this.add(chartPanel, BorderLayout.CENTER);
    this.setName(tabName);
    refreshPie(app);
  }
}
