/*
 * $Id$
 */

package csbase.client.applications.filetransferclient.actions;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;

/**
 * Ao de conexo a um servidor
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ConnectionOffAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  final public void actionDone(final JComponent component) {
    final FileTransferClient application = getApplication();
    application.setConnection(null);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public ImageIcon getStandardImageIcon() {
    return null;
  }

  /**
   * Construtor
   * 
   * @param application a aplicao
   */
  public ConnectionOffAction(FileTransferClient application) {
    super(application);
  }
}
