/**
 * $Id$
 */

package csbase.client.project.action;

import java.awt.event.ActionEvent;
import java.util.List;

import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectFileContainer;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;

/**
 * Ao para exportar arquivos para o disco local.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CommonExchangeExportAction extends CommonExchangeAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent ae) {

    // Verifica se a aplicao j est executando.
    boolean isFileExchangerRunning = this.isFileExchangerRunning();

    final FileExchanger fileExchanger = getFileExchanger();
    final DesktopComponentFrame desktopFrame =
      DesktopFrame.getInstance().getDesktopFrame();
    if (fileExchanger == null) {
      showError(desktopFrame, getString("launch.error"));
      return;
    }
    final List<ClientProjectFile> selectedFiles = getSelectedRemoteFiles();
    try {
      fileExchanger.exportToDirectory(selectedFiles, new Boolean(
        isFileExchangerRunning));
    }
    catch (Exception e) {
      final DesktopFrame dsk = DesktopFrame.getInstance();
      StandardErrorDialogs.showErrorDialog(dsk.getDesktopFrame(), e);
    }
  }

  /**
   * Construtor
   * 
   * @param container o container de projetos
   * 
   */
  public CommonExchangeExportAction(ProjectFileContainer container) {
    super(container);
  }
}
