/*
 * ProjectCreationAction.java
 * 
 * $Author$ $Revision$ - $Date: 2008-09-17 10:05:53 -0300
 * (Wed, 17 Sep 2008) $
 */
package csbase.client.project.action;

import java.awt.Window;
import java.awt.event.ActionEvent;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectTree;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommonClientProject;

/**
 * Ao que cria um projeto de um usurio.
 */
public class CommonProjectCreationAction extends ProjectAction {

  /**
   * Executa a ao.No csbase, criamos um projeto apenas com as informacoes
   * comuns.
   * 
   * @param e .
   */
  @Override
  public void actionPerformed(ActionEvent e) {

    final Window window = getWindow();
    final DesktopFrame desktopFrame = DesktopFrame.getInstance();
    final CommonClientProject newProject =
      desktopFrame.openProjectCreationDialog(window);

    if (newProject == null) {
      return;
    }
    /*
     * Fecha o projeto corrente salvando as configuracoes
     */
    final ProjectCloseAction closeAction =
      new ProjectCloseAction(getProjectTree());
    closeAction.actionPerformed(e);
    try {
      setCurrentProject(newProject);
    }
    catch (Exception ex) {
      StandardErrorDialogs.showErrorDialog(window, getTitle(), ex);
    }
  }

  /**
   * Obtm o nome da ao.
   * 
   * @return .
   */
  @Override
  public String getName() {
    return LNG.get("PRJ_CREATION");
  }

  /**
   * Constri a ao.
   * 
   * @param treeView .
   */
  public CommonProjectCreationAction(ProjectTree treeView) {
    super(treeView);
  }

}
