/*
 * $Id: ImageViewerRestoreAction.java 112198 2010-11-05 21:03:43Z clinio $
 */
package csbase.client.applications.imageviewer.actions.io;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.imageviewer.ImageViewer;
import csbase.client.applications.imageviewer.actions.ImageViewerAction;

/**
 * Restaura a imagem original.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ImageViewerRestoreAction extends ImageViewerAction {

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public ImageViewerRestoreAction(ImageViewer application) {
    super(application);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ImageIcon getDefaultIcon() {
    return ApplicationImages.ICON_RESET_16;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) {
    final ImageViewer application = getApplication();
    application.restoreOriginalImage();
    application.setSaveNeeded(false);
  }

}
