/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmCreateDataPanel;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmSelectionPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonEditTabbedPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonInfoEditPanel;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.applications.algorithmsmanager.versiontree.PropertiesPanel;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmProperty;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.gui.GBC;

public class AlgorithmCreateInfoPanel
extends CommonInfoEditPanel {
    private JTextField algorithmNameField;
    private JTextField algorithmIdField;
    private JCheckBox generateIdCheckBox;
    private List<AlgorithmProperty> algorithmProperties;
    private PropertiesPanel propertiesPanel;
    private JPanel mainPanel;
    private boolean isEditing;

    public AlgorithmCreateInfoPanel(CommonEditTabbedPanel algoPane) {
        super(algoPane);
        this.setCancelActionState(true);
    }

    private Window getWindow() {
        return ((AlgorithmsManager)this.getApplication()).getApplicationFrame();
    }

    private JPanel getAlgoCreatePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder());
        this.algorithmProperties = AlgorithmManagementProxy.getAlgorithmProperties(this.getWindow());
        this.propertiesPanel = new PropertiesPanel(this.algorithmProperties, new Hashtable<String, String>(), this.getString("AlgorithmCreateInfoPanel.label.properties"), this.getWindow(), true);
        if (this.algorithmProperties.size() > 0) {
            panel.add((Component)this.propertiesPanel.getPropertiesPanel(), new GBC(0, 0).horizontal().west().insets(0, 0, 0, 0));
        }
        panel.add((Component)this.buildEmptyPanel(), new GBC(0, 1).both().west().insets(0, 0, 0, 0));
        return panel;
    }

    private JPanel getAlgorithmNamePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        String maxSize = Integer.toString(50);
        String maxInLabel = MessageFormat.format(this.getString("AlgorithmCreateInfoPanel.msg.name_max"), maxSize);
        JLabel nameLabel = new JLabel(this.getString("AlgorithmCreateInfoPanel.label.name") + " " + maxInLabel);
        this.algorithmNameField = new JTextField(30);
        this.algorithmNameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AlgorithmCreateInfoPanel.this.apply();
                }
            }
        });
        this.algorithmNameField.addCaretListener(e -> {
            boolean hasName;
            JTextField tf = (JTextField)e.getSource();
            this.isEditing = hasName = !tf.getText().trim().isEmpty();
            this.setApplyActionState(hasName);
        });
        String maxInId = MessageFormat.format(this.getString("AlgorithmCreateInfoPanel.msg.id_max"), maxSize);
        JLabel idLabel = new JLabel(this.getString("AlgorithmCreateInfoPanel.label.id") + " " + maxInId);
        this.algorithmIdField = new JTextField(30);
        this.algorithmIdField.addCaretListener(e -> {
            boolean hasName;
            JTextField tf = (JTextField)e.getSource();
            this.isEditing = hasName = !tf.getText().trim().isEmpty();
        });
        JPanel idPanel = new JPanel(new GridBagLayout());
        idPanel.add((Component)idLabel, new GBC(0, 0).none().west().insets(5, 15, 5, 5));
        idPanel.add((Component)this.algorithmIdField, new GBC(1, 0).horizontal().west().insets(5, 5, 5, 15));
        idPanel.setVisible(false);
        JLabel generateIdLabel = new JLabel(this.getString("AlgorithmCreateInfoPanel.label.generate_id"));
        this.generateIdCheckBox = new JCheckBox();
        this.generateIdCheckBox.setSelected(true);
        this.generateIdCheckBox.addActionListener(e -> {
            AbstractButton abstractButton = (AbstractButton)e.getSource();
            boolean selected = abstractButton.getModel().isSelected();
            idPanel.setVisible(!selected);
        });
        panel.add((Component)nameLabel, new GBC(0, 0).none().west().insets(5, 5, 5, 5));
        panel.add((Component)this.algorithmNameField, new GBC(1, 0).horizontal().west().insets(5, 5, 5, 5));
        panel.add((Component)generateIdLabel, new GBC(0, 1).none().west().insets(5, 5, 5, 5));
        panel.add((Component)this.generateIdCheckBox, new GBC(1, 1).horizontal().west().insets(5, 5, 5, 5));
        panel.add((Component)idPanel, new GBC(0, 2).gridwidth(2).horizontal().west());
        return panel;
    }

    protected String getFieldCategoryName() {
        return this.algorithmNameField.getText();
    }

    @Override
    public void initializeData() {
        this.algorithmNameField.requestFocus();
    }

    @Override
    protected JPanel buildMainInfoPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            JPanel namePanel = this.getAlgorithmNamePanel();
            JPanel algoPanel = this.getAlgoCreatePanel();
            this.mainPanel.add((Component)namePanel, new GBC(0, 0).horizontal().west().insets(0, 0, 0, 0));
            this.mainPanel.add((Component)algoPanel, new GBC(0, 1).both().west().insets(0, 0, 0, 0));
        }
        return this.mainPanel;
    }

    protected boolean createAlgorithm() {
        AlgorithmInfo algorithmCreated;
        String algoName = this.algorithmNameField.getText().trim();
        if (((AlgorithmsManager)this.getApplication()).containsAlgorithm(algoName)) {
            ((AlgorithmsManager)this.getApplication()).showError(this.getString("AlgorithmCreateInfoPanel.msg.error.create.algorithm_exists"));
            this.algorithmNameField.requestFocus();
            return false;
        }
        Hashtable<String, String> fieldValues = this.propertiesPanel.getProperties();
        String algoId = null;
        if (!this.generateIdCheckBox.isSelected()) {
            algoId = this.algorithmIdField.getText().trim();
            if (!this.isValidId(algoId)) {
                ((AlgorithmsManager)this.getApplication()).showError(this.getString("AlgorithmCreateInfoPanel.msg.error.create.algorithm_id_invalid"));
                this.algorithmIdField.requestFocus();
                return false;
            }
            if (((AlgorithmsManager)this.getApplication()).containsAlgorithmWithId(algoId)) {
                ((AlgorithmsManager)this.getApplication()).showError(this.getString("AlgorithmCreateInfoPanel.msg.error.create.algorithm_id_exists"));
                this.algorithmIdField.requestFocus();
                return false;
            }
        }
        if ((algorithmCreated = this.getAlgorithmCreateDataPanel().createAlgorithm(algoName, algoId, fieldValues)) == null) {
            ((AlgorithmsManager)this.getApplication()).showError(this.getString("AlgorithmCreateInfoPanel.msg.error.create.no_sucess"));
            this.algorithmNameField.requestFocus();
            return false;
        }
        return true;
    }

    private boolean isValidId(String algoId) {
        String trimmedId = algoId.trim();
        if (trimmedId.isEmpty()) {
            return false;
        }
        if (trimmedId.length() > 50) {
            return false;
        }
        String normalizedId = FileUtils.fixDirectoryName((String)trimmedId);
        return normalizedId.equals(trimmedId);
    }

    @Override
    protected void apply() {
        this.isEditing = false;
        this.createAlgorithm();
    }

    @Override
    protected void cancel() {
        boolean confirmCancelling;
        boolean bl = confirmCancelling = !this.wasModified() || this.wasModified() && this.confirmCancelling();
        if (confirmCancelling) {
            this.getAlgorithmCreateDataPanel().cancel();
            AlgorithmListItem selectedAlgorithm = this.getSelectionPanel().getSelectedAlgorithm();
            if (selectedAlgorithm != null) {
                this.getSelectionPanel().selectAlgorithm(selectedAlgorithm.getItem());
            }
        }
    }

    private AlgorithmSelectionPanel getSelectionPanel() {
        return this.getAlgorithmCreateDataPanel().getSelectionPanel();
    }

    private AlgorithmCreateDataPanel getAlgorithmCreateDataPanel() {
        return (AlgorithmCreateDataPanel)this.getEditPanel();
    }

    private boolean confirmCancelling() {
        int confirm = ((AlgorithmsManager)this.getApplication()).showOptionDialog(this.getString("AlgorithmCreateInfoPanel.msg.cancel.confirm"), new String[]{this.getString("AlgorithmCreateInfoPanel.msg.cancel.confirm.yes"), this.getString("AlgorithmCreateInfoPanel.msg.cancel.confirm.no")});
        if (confirm == 0) {
            this.isEditing = false;
            return true;
        }
        return false;
    }

    @Override
    public void setDataChanged() {
        this.isEditing = false;
        this.changeOperationsState(this.isEditing);
    }

    @Override
    protected String getTitle() {
        return ((AlgorithmsManager)this.getApplication()).getString("CommonEditTabbedPanel.tab.info.basic");
    }

    @Override
    public boolean wasModified() {
        return this.isEditing;
    }
}

