/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectAttribute;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.util.ArrayList;
import java.util.List;

public class ChangeServerOwnerProjectTask
extends ProjectsManagerTask<List<ProjectsManagerData>> {
    private List<ProjectsManagerData> projects;
    private String serverName;

    public ChangeServerOwnerProjectTask(ProjectsManager projectsManager, List<ProjectsManagerData> projects, String serverName) {
        super(projectsManager);
        this.projects = projects;
        this.serverName = serverName;
    }

    protected void performTask() throws Exception {
        ArrayList<ProjectsManagerData> list = new ArrayList<ProjectsManagerData>();
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        for (int i = 0; i < this.projects.size(); ++i) {
            try {
                CommonClientProject ccp = psi.openProject(this.projects.get(i).getProjectId(), false);
                ccp.setAttribute(ProjectAttribute.SERVER_NAME.getAttributeKey(), (Object)this.serverName);
                ccp.modify();
                ccp.close(false);
                continue;
            }
            catch (Exception e) {
                list.add(this.projects.get(i));
            }
        }
        this.setResult(list);
    }
}

