/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.serverdiagnostic.monitor;

import csbase.client.applications.ApplicationImages;
import csbase.logic.diagnosticservice.ValidationStatus;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;

public class ValidationStatusListCellRenderer
extends DefaultListCellRenderer {
    public ValidationStatusListCellRenderer() {
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        ValidationStatus status = (ValidationStatus)value;
        Icon icon = this.getIcon(list, value, index, isSelected, cellHasFocus);
        label.setText(status.message);
        label.setIcon(icon);
        if (status.detailMessage != null) {
            label.setToolTipText("<html><p width=\"500\">" + status.detailMessage + "</p></html>");
        }
        label.setHorizontalAlignment(10);
        return label;
    }

    private Icon getIcon(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        switch (((ValidationStatus)value).code) {
            case OK: {
                return ApplicationImages.GREEN_BALL_16;
            }
            case WARNING: {
                return ApplicationImages.YELLOW_BALL_16;
            }
            case ERROR: 
            case UNAVAILABLE: 
            case INITIATING: {
                return ApplicationImages.RED_BALL_16;
            }
        }
        return null;
    }
}

