/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui.log;

import csbase.client.util.event.EventListener;
import csbase.client.util.gui.LinedTextArea;
import csbase.client.util.gui.log.AutoReloadable;
import csbase.client.util.gui.log.LogPanel;
import csbase.client.util.gui.log.LogPanelReloader;
import csbase.client.util.gui.log.enums.FontSize;
import csbase.client.util.gui.log.enums.FontType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tecgraf.javautils.gui.GBC;

public final class LogPanelTextArea
extends JPanel {
    private static final Font FONT_DEFAULT = new Font("Monospaced", 0, 12);
    private LinedTextArea textArea;
    private JLabel header;

    private static final String getString(String tag, Object ... args) {
        return LogPanel.getString("TextArea." + tag, args);
    }

    public final FontSize getFontSize() {
        Font font = this.textArea.getFont();
        int isize = font.getSize();
        return FontSize.getFontSizeByInt(isize);
    }

    public final FontType getFontType() {
        Font font = this.textArea.getFont();
        String name = font.getName();
        return FontType.getFontTypeByName(name);
    }

    public final void goToHead() {
        String text = this.textArea.getText();
        if (text == null) {
            return;
        }
        this.textArea.setCaretPosition(0);
    }

    public final void goToTail() {
        String text = this.textArea.getText();
        if (text == null) {
            return;
        }
        int textLength = text.length();
        if (textLength == 0) {
            return;
        }
        this.textArea.setCaretPosition(textLength - 1);
    }

    private void initializeComponents(AutoReloadable logPanel, boolean scrollable, String headerText) {
        this.textArea = new LinedTextArea();
        this.textArea.setEditable(true);
        this.textArea.setFont(FONT_DEFAULT);
        this.textArea.setEditable(false);
        this.textArea.setColumns(132);
        if (headerText != null) {
            this.header = new JLabel(headerText);
            this.header.setFont(FONT_DEFAULT);
        }
        this.updateBgColor(logPanel.getReloader().isRunning());
        logPanel.getReloader().addStatusChangedEventListener(new EventListener<LogPanelReloader.StatusChangedEvent>(){

            @Override
            public void eventFired(LogPanelReloader.StatusChangedEvent event) {
                LogPanelTextArea.this.updateBgColor(event.isRunning());
            }
        });
        this.setLayout(new GridBagLayout());
        int i = 0;
        if (this.header != null) {
            this.add((Component)this.header, new GBC(0, i++).horizontal());
        }
        if (scrollable) {
            JScrollPane scrollPane = new JScrollPane(this.textArea);
            int mode = 22;
            scrollPane.setVerticalScrollBarPolicy(22);
            this.add((Component)scrollPane, new GBC(0, i).both());
        } else {
            this.add((Component)this.textArea, new GBC(0, i).both());
        }
    }

    public final void setFontSize(FontSize size) {
        Font oldFont = this.textArea.getFont();
        int isize = size.getSize();
        int style = oldFont.getStyle();
        String name = oldFont.getName();
        Font newFont = new Font(name, style, isize);
        this.textArea.setFont(newFont);
        if (this.header != null) {
            this.header.setFont(newFont);
        }
    }

    public final void setFontType(FontType type) {
        Font oldFont = this.textArea.getFont();
        int size = oldFont.getSize();
        int style = oldFont.getStyle();
        String typeName = type.getTypeName();
        Font newFont = new Font(typeName, style, size);
        this.textArea.setFont(newFont);
        if (this.header != null) {
            this.header.setFont(newFont);
        }
    }

    public void setPrefix(long page) {
        if (1L >= page) {
            this.textArea.setPrefix(null);
        } else {
            String prefix = LogPanelTextArea.getString("prefix", page);
            this.textArea.setPrefix(prefix);
        }
    }

    public final void setText(String text) {
        this.textArea.setText(text);
    }

    private void updateBgColor(boolean reloading) {
        Color on = new Color(200, 200, 200);
        Color off = new Color(220, 220, 220);
        Color clr = reloading ? on : off;
        this.textArea.setBackground(clr);
        if (this.header != null) {
            this.header.setOpaque(true);
            this.header.setBackground(clr);
        }
    }

    public LogPanelTextArea(AutoReloadable logPanel, boolean scrollable, String headerText) {
        this.initializeComponents(logPanel, scrollable, headerText);
        this.setFontType(FontType.MONOSPACED);
    }

    public LogPanelTextArea(AutoReloadable logPanel, boolean scrollable) {
        this(logPanel, scrollable, null);
    }
}

