/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.webviewer;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.ApplicationProject;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.externalresources.ExternalResources;
import csbase.client.util.StandardErrorDialogs;
import java.awt.Window;
import java.net.URL;

public class WebViewer
extends ApplicationProject {
    private static final String DEFAULT_URL_PROPERTY = "default.url";

    @Override
    public void postInitialization() throws ApplicationException {
        this.closeApplication();
    }

    @Override
    public void killApplication() {
    }

    @Override
    public boolean userCanKillApplication() {
        return true;
    }

    private void openURL(String urlStr) {
        try {
            URL url = new URL(urlStr);
            if (ExternalResources.getInstance().isEnabled()) {
                ExternalResources.getInstance().showDocument(url);
                return;
            }
            throw new Exception(this.getString("WEB_VIEWER_SERVICE_UNAVAILABLE"));
        }
        catch (Exception e) {
            String msg = this.getString("WEB_VIEWER_OPEN_URL_ERROR_MESSAGE", new Object[]{urlStr, e.getMessage()});
            DesktopComponentFrame owner = this.getDesktopFrame().getDesktopFrame();
            String title = this.getString("WEB_VIEWER_OPEN_URL_ERROR_TITLE");
            StandardErrorDialogs.showErrorDialog((Window)owner, title, msg);
            return;
        }
    }

    public WebViewer(String id) {
        super(id);
        String urlStr = this.getStringSpecificProperty(DEFAULT_URL_PROPERTY);
        this.openURL(urlStr);
    }
}

