/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.actions.FlowApplicationAction;
import csbase.client.preferences.PreferenceManager;
import csbase.client.preferences.types.PVList;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.AlgorithmInfo;
import java.awt.event.ActionEvent;
import java.util.List;

public class AlgorithmFavoriteAddAction
extends FlowApplicationAction {
    private AlgorithmInfo versionInfo;

    public AlgorithmFavoriteAddAction(FlowApplication application) {
        super(application, ApplicationImages.ICON_FAVORITE_16);
    }

    @Override
    public void handleActionPerformed(ActionEvent e) {
        this.addAsFavoriteAlgorithm(this.versionInfo);
        ((FlowApplication)this.getApplication()).reloadAlgorithmTree();
    }

    public final void addAsFavoriteAlgorithm(AlgorithmInfo info) {
        AlgorithmInfo algorithm = AlgorithmManagementProxy.getAlgorithmInfoById(info.getId(), null, AlgorithmManagementProxy.AlgorithmOperation.EXECUTE_ALGORITHM);
        if (algorithm == null) {
            return;
        }
        List<String> ids = FlowApplication.getFavoriteAlgorithmsIds();
        if (ids.contains(info.getId())) {
            return;
        }
        ids.add(info.getId());
        PVList fav = FlowApplication.getFavorites();
        fav.setValue(ids);
        PreferenceManager.getInstance().savePreferences();
    }

    public void setAlgorithmInfo(AlgorithmInfo algorithmInfo) {
        this.versionInfo = algorithmInfo;
    }
}

