/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.filters;

import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.messages.PickGraphMessage;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import tecgraf.vix.TypeVO;

public final class HighlightElementFilter
extends WorkspaceFilter {
    private Collection<GraphElement> elementCollection;

    public HighlightElementFilter(Workspace workspace) {
        super(workspace);
    }

    public void callbackMove(Point2D pt, MouseEvent ev) {
        this.restart();
        PickGraphMessage message = new PickGraphMessage();
        message.sendVO((TypeVO)this);
        Graph graph = message.getGraph();
        this.elementCollection = graph.getElementCollection(pt);
        if (!this.elementCollection.isEmpty()) {
            for (GraphElement element : this.elementCollection) {
                element.turnOnHighlight(pt);
            }
            this.repaint();
        } else {
            this.elementCollection = null;
        }
        super.callbackMove(pt, ev);
    }

    @Override
    public void wasElementRemoved(Graph graph, GraphElement element) {
        this.restart();
    }

    @Override
    public void wasReseted(Graph graph) {
        this.restart();
    }

    private void restart() {
        if (this.elementCollection != null) {
            for (GraphElement element : this.elementCollection) {
                element.turnOffHighlight();
            }
            this.repaint();
            this.elementCollection = null;
        }
    }
}

