/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences.editors;

import csbase.client.facilities.configurabletable.table.ColumnState;
import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;

public class PVTablesEditor
extends PreferenceEditor<Map<String, List<ColumnState>>> {
    public PVTablesEditor(PreferenceValue<Map<String, List<ColumnState>>> pv) {
        super(pv);
    }

    @Override
    protected JComponent createComponent() {
        Map statesMap = (Map)this.getValue();
        JPanel allTablesPanel = new JPanel(new GridBagLayout());
        int column = 0;
        if (!statesMap.isEmpty()) {
            for (String tableId : statesMap.keySet()) {
                JPanel tablePanel = this.createPanel(statesMap, tableId);
                allTablesPanel.add((Component)tablePanel, new GBC(column++, 0).north().horizontal());
            }
        } else {
            JLabel noTables = new JLabel(this.getString("no.tables.defined"));
            noTables.setFont(font);
            allTablesPanel.add(noTables);
        }
        this.setTitledBorder(allTablesPanel);
        return allTablesPanel;
    }

    private JPanel createPanel(Map<String, List<ColumnState>> statesMap, String tableId) {
        JPanel panel = new JPanel(new GridBagLayout());
        int row = 0;
        int column = 0;
        int lineNumber = statesMap.get(tableId).size();
        if (lineNumber > 20 && lineNumber < 30) {
            int n = lineNumber = lineNumber % 2 == 0 ? lineNumber / 2 : lineNumber / 2 + 1;
        }
        if (lineNumber >= 30) {
            lineNumber = 15;
        }
        for (final ColumnState state : statesMap.get(tableId)) {
            String columnName = state.getColumnId();
            if (this.hasString(columnName)) {
                columnName = this.getString(columnName);
            }
            final JCheckBox checkbox = new JCheckBox(columnName);
            checkbox.setSelected(state.isVisible());
            checkbox.setFont(font);
            checkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    state.setVisible(checkbox.isSelected());
                    PVTablesEditor.this.notifyListeners();
                }
            });
            checkbox.setEnabled(this.isEditable());
            String tableLabel = tableId;
            if (this.hasString(tableLabel)) {
                tableId = this.getString(tableLabel);
            }
            this.setTitledBorder(panel, tableLabel);
            panel.add((Component)checkbox, new GBC(column, row++).west().left(10).right(10));
            if (row != lineNumber) continue;
            row = 0;
            ++column;
        }
        return panel;
    }
}

