/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser;

import csbase.client.util.filechooser.ClientFileChooser;
import csbase.client.util.filechooser.ClientFileChooserCardinality;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.filetablepanel.ClientFileTablePanel;
import csbase.client.util.filechooser.filetablepanel.ClientTableActionListener;
import csbase.logic.ClientFile;
import java.util.List;

class ClientFileChooserActionListener
implements ClientTableActionListener {
    private final ClientFileChooser chooser;

    ClientFileChooserActionListener(ClientFileChooser chooser) {
        this.chooser = chooser;
    }

    @Override
    public void actionPerformed(ClientFileTablePanel panel, List<ClientFile> files) {
        if (files == null || files.size() == 0) {
            return;
        }
        ClientFileChooserCardinality card = this.chooser.getCardinality();
        switch (card) {
            case SINGLE_CHOOSE: {
                ClientFile selected = files.get(0);
                this.treatSingleFile(selected);
                break;
            }
            case MULTIPLE_CHOOSE: {
                this.treatMultipleSelection(files);
            }
        }
    }

    private void treatMultipleSelection(List<ClientFile> files) {
        int size = files.size();
        if (size == 1) {
            ClientFile selected = files.get(0);
            this.treatSingleFile(selected);
        }
    }

    private void treatSingleFile(ClientFile file) {
        if (file.isDirectory()) {
            this.chooser.setCurrentDirectory(file);
            return;
        }
        if (!file.canRead()) {
            return;
        }
        if (this.chooser.getSelectionMode() == ClientFileChooserSelectionMode.FILES_ONLY) {
            this.chooser.closeOnSingleFile(file);
        }
    }
}

