package csbase.client.applications.sgamonitor.columns.util;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;

/**
 * Classe que define o renderizador do um job processor.
 * 
 * @author Tecgraf
 */
public class NodeJobProcessorRenderer extends DefaultTableCellRenderer {

  /**
   * Construtor padro.
   */
  public NodeJobProcessorRenderer() {
    super();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
      row, column);

    JobProcessorPair jobProcessor = (JobProcessorPair) value;

    if (jobProcessor.getJobs() < 0) {
      setText(jobProcessor.toString().replaceFirst("-1",
        AbstractConfigurableColumn.NO_VALUE));
    }
    else {
      setText(jobProcessor.toString());
    }
    return this;
  }
}