/*
 * $Header$
 * $Revision$
 * $Date$
 * $Author$
 */
package csbase.client.util;

import java.net.URL;
import java.util.Hashtable;

import javax.swing.Icon;
import javax.swing.ImageIcon;

import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;

/**
 * Cache de Icones.
 *
 * @author <a href="mailto:jorgeads@tecgraf.puc-rio.br">Jorge Alexandre</a>
 */
public final class IconCache {
  private static Hashtable iconTable = new Hashtable();

  static {
    RestartManager.getInstance().addListener(
      new RestartListener() {
        public void restart() {
          IconCache.iconTable = new Hashtable();
        }
      });
  }

  /**
   * Obtm o cone a partir da URL da imagem.
   *
   * @param imageURL URL da imagem.
   *
   * @return .
   */
  public static Icon getIcon(URL imageURL) {
    Icon icon = (Icon)iconTable.get(imageURL);
    if (icon == null) {
      icon = new ImageIcon(imageURL);
      iconTable.put(imageURL, icon);
    }
    return icon;
  }
}
