/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.models;

import csbase.logic.FileInfoSearchResult;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SearchResultTableModel
extends AbstractTableModel {
    private static final int ROW_INDEX_COL = 0;
    private static final int FILENAME_COL = 1;
    private static final int PRJNAME_COL = 2;
    private static final int PATH_COL = 3;
    private static final int OWNER_COL = 4;
    private final String[] colNames;
    private List<FileInfoSearchResult> resultsList;

    @Override
    public int getColumnCount() {
        return this.colNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.resultsList == null) {
            return 0;
        }
        return this.resultsList.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.colNames[col];
    }

    public Class<String> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void resetList() {
        this.resultsList = new ArrayList<FileInfoSearchResult>();
        this.fireTableDataChanged();
    }

    public void addAll(List<FileInfoSearchResult> newValues) {
        this.resultsList.addAll(newValues);
        this.fireTableDataChanged();
    }

    public SearchResultTableModel(String[] colNames) {
        this.colNames = colNames;
        this.resultsList = new ArrayList<FileInfoSearchResult>();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return "" + (rowIndex + 1);
        }
        FileInfoSearchResult resultLine = this.resultsList.get(rowIndex);
        if (columnIndex == 1) {
            return resultLine.getFileName();
        }
        if (columnIndex == 2) {
            return resultLine.getProjectName();
        }
        if (columnIndex == 3) {
            return resultLine.getFilePath();
        }
        if (columnIndex == 4) {
            return resultLine.getOwnerName();
        }
        return null;
    }

    public Object getProjectId(int rowIndex) {
        FileInfoSearchResult resultLine = this.resultsList.get(rowIndex);
        return resultLine.getProjectId();
    }

    public boolean isWritable(int rowIndex) {
        return this.resultsList.get(rowIndex).isWritable();
    }
}

