/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.proxy.LocateMissingAllocatedProjectsTask;
import csbase.client.desktop.DesktopFrame;
import csbase.logic.CommonClientProject;
import javax.swing.ImageIcon;

public class OpenProjectCreationDialogAction
extends ProjectsManagerAction {
    public OpenProjectCreationDialogAction(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void actionDone() throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        ApplicationFrame appFrame = projectsManager.getApplicationFrame();
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        CommonClientProject ccp = desktopFrame.openProjectCreationDialog(appFrame);
        if (ccp == null && ProjectsManager.isCurrentUserAdmin()) {
            LocateMissingAllocatedProjectsTask lmapt = new LocateMissingAllocatedProjectsTask(projectsManager);
            String title = this.getString("OpenProjectCreationDialogAction.title");
            String msg = this.getString("OpenProjectCreationDialogAction.message");
            lmapt.execute(projectsManager.getApplicationFrame(), title, msg);
            if (lmapt.wasCancelled()) {
                String err = this.getString("OpenProjectCreationDialogAction.cancelled.message");
                lmapt.showError(err);
                return;
            }
            if (!lmapt.getStatus()) {
                Exception exception = lmapt.getError();
                throw exception;
            }
            boolean result = (Boolean)lmapt.getResult();
            if (!result) {
                lmapt.showError(this.getString("OpenProjectCreationDialogAction.project.creation.error.message"));
            }
        }
        projectsManager.refreshProjectsTable();
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ApplicationImages.ICON_ADD_16;
    }
}

