/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.actions;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.actions.AlgorithmsManagerAction;
import csbase.client.applications.algorithmsmanager.report.core.ITest;
import csbase.client.applications.algorithmsmanager.report.core.TestDialog;
import csbase.client.applications.algorithmsmanager.report.implementations.AlgorithmManagerSubjectFactory;
import csbase.client.applications.algorithmsmanager.report.implementations.SimpleConfiguratorSource;
import csbase.client.applications.algorithmsmanager.report.implementations.TestConfiguratorInvalid;
import csbase.client.applications.algorithmsmanager.report.implementations.TestEmptyAlgorithm;
import csbase.client.applications.algorithmsmanager.report.implementations.TestHelpMissing;
import csbase.client.applications.algorithmsmanager.report.implementations.TestMissingPlatform;
import csbase.client.applications.algorithmsmanager.report.implementations.TestOutdatedFlow;
import csbase.client.applications.algorithmsmanager.report.implementations.TestParameterUsage;
import csbase.logic.Platform;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

public class RunTestsAction
extends AlgorithmsManagerAction {
    private AlgorithmManagerSubjectFactory subjectFactory = null;

    public RunTestsAction(AlgorithmsManager application) {
        super(application);
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        List<ITest<?>> allTests = this.buildAllTests();
        this.subjectFactory = this.getSubjectFactory();
        ApplicationFrame frame = ((AlgorithmsManager)this.getApplication()).getApplicationFrame();
        TestDialog selectionDialog = new TestDialog(allTests, this.subjectFactory, ((AlgorithmsManager)this.getApplication()).getLocale(), frame);
        selectionDialog.setVisible(true);
    }

    private AlgorithmManagerSubjectFactory getSubjectFactory() {
        if (this.subjectFactory == null) {
            this.subjectFactory = new AlgorithmManagerSubjectFactory((Application)this.getApplication());
        }
        return this.subjectFactory;
    }

    private List<ITest<?>> buildAllTests() throws Exception {
        ApplicationFrame frame = ((AlgorithmsManager)this.getApplication()).getApplicationFrame();
        ArrayList allTests = new ArrayList();
        allTests.add(new TestOutdatedFlow(frame));
        allTests.add(new TestMissingPlatform(Platform.getAllPlatforms(), frame));
        allTests.add(new TestConfiguratorInvalid(frame));
        allTests.add(new TestEmptyAlgorithm(frame));
        allTests.add(new TestHelpMissing(frame));
        allTests.add(new TestParameterUsage(new SimpleConfiguratorSource((Application)this.getApplication()), frame));
        return allTests;
    }

    public void updateToReload() {
        this.getSubjectFactory().reset();
    }
}

