/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.Application;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.versiontree.AlgorithmPropertiesTableListener;
import csbase.client.applications.algorithmsmanager.versiontree.AlgorithmPropertiesTableModel;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.table.EditableCellRenderer;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmProperty;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.StandardDialogs;

public class AlgorithmsPropertiesDialog
extends DesktopComponentFrame
implements AlgorithmPropertiesTableListener {
    private AlgorithmsManager application;
    private JButton cancelButton;
    private JButton applyButton;
    private JTable algoTable;
    private String[] columnNames = null;
    private Object[][] data = null;
    private List<AlgorithmProperty> properties = null;
    private AlgorithmInfo[] algos = null;
    private AlgorithmInfo[] sortedAlgos = null;
    private AlgorithmPropertiesTableModel model;
    private boolean askForConfirmation = false;
    private static int YES_OPTION = 0;
    private static int NO_OPTION = 1;

    private AlgorithmsPropertiesDialog(Object index, AlgorithmsManager application) {
        super(index, application.getApplicationFrame(), LNG.get((String)"ias.algorithm.AlgoManagerFrame.title.properties_management"));
        this.application = application;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                AlgorithmsPropertiesDialog.this.showSaveDialog();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel description = new JLabel(this.getApplication().getString("AlgorithmsPropertiesDialog.description"));
        this.algoTable = this.makeAlgoTable();
        JScrollPane tablePane = new JScrollPane(this.algoTable);
        tablePane.setHorizontalScrollBarPolicy(30);
        this.getContentPane().add((Component)description, new GBC(0, 0).none().west().insets(12, 12, 5, 12));
        this.getContentPane().add((Component)tablePane, new GBC(0, 1).both().center().weights(1.0, 1.0).insets(12, 12, 12, 12));
        this.getContentPane().add((Component)this.createButtonsPanel(), new GBC(0, 2).both().center().weights(0.0, 0.0).insets(0, 0, 5, 0));
        this.setPreferredSize(new Dimension(650, 350));
        this.pack();
        if (DesktopFrame.getInstance() == null) {
            this.setLocationRelativeTo(null);
        } else {
            this.center(DesktopFrame.getInstance().getDesktopFrame());
        }
        ((AlgorithmPropertiesTableModel)this.algoTable.getModel()).addListener(this);
        this.askForConfirmation = false;
    }

    public static AlgorithmsPropertiesDialog getFrame(AlgorithmsManager application) {
        String index = AlgorithmsPropertiesDialog.class.getName();
        DesktopComponentFrame frame = AlgorithmsPropertiesDialog.getDesktopComponentFrame(index);
        if (frame == null) {
            frame = new AlgorithmsPropertiesDialog((Object)index, application);
        }
        return (AlgorithmsPropertiesDialog)frame;
    }

    private JTable makeAlgoTable() {
        int i;
        final AlgorithmServiceInterface algoService = ClientRemoteLocator.algorithmService;
        RemoteTask<List<AlgorithmProperty>> task = new RemoteTask<List<AlgorithmProperty>>(){

            public void performTask() throws Exception {
                this.setResult(algoService.getAlgorithmProperties());
            }
        };
        boolean execute = task.execute(null, LNG.get((String)"SCHEDULER_ACCESSING_TITLE"), LNG.get((String)"SCHEDULER_ACCESSING_MESSAGE"));
        if (execute) {
            this.properties = (List)task.getResult();
            this.columnNames = new String[this.properties.size() + 1];
            this.columnNames[0] = LNG.get((String)"ias.algorithm.AlgoManagerFrame.label.algorithm");
            for (int i2 = 0; i2 < this.properties.size(); ++i2) {
                this.columnNames[i2 + 1] = this.properties.get(i2).getLabel();
            }
        }
        this.algos = AlgorithmManagementProxy.getAllAlgorithmInfos(this.getApplication().getApplicationFrame(), AlgorithmManagementProxy.AlgorithmOperation.ADMIN_ALGORITHM);
        Vector sortedVectorAlgos = new Vector();
        Collections.addAll(sortedVectorAlgos, this.algos);
        Collections.sort(sortedVectorAlgos);
        this.sortedAlgos = sortedVectorAlgos.toArray(new AlgorithmInfo[sortedVectorAlgos.size()]);
        this.data = new String[this.sortedAlgos.length][this.columnNames.length];
        for (i = 0; i < this.sortedAlgos.length; ++i) {
            this.data[i][0] = this.sortedAlgos[i].getName();
        }
        for (i = 1; i < this.columnNames.length; ++i) {
            for (int j = 0; j < this.sortedAlgos.length; ++j) {
                String propKey = this.properties.get(i - 1).getKey();
                String propValue = this.sortedAlgos[j].getPropertyValue(propKey);
                this.data[j][i] = propValue == null ? "" : propValue;
            }
        }
        this.model = new AlgorithmPropertiesTableModel(this.data, this.columnNames);
        JTable algoPropertiesTable = new JTable(this.model);
        algoPropertiesTable.setDefaultRenderer(Object.class, new EditableCellRenderer());
        algoPropertiesTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        return algoPropertiesTable;
    }

    private JPanel createButtonsPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.cancelButton = new JButton(this.getApplication().getString("AlgorithmsPropertiesDialog.button.cancel"));
        this.cancelButton.addActionListener(ev -> this.showSaveDialog());
        this.applyButton = new JButton(this.getApplication().getString("AlgorithmsPropertiesDialog.button.apply"));
        this.applyButton.addActionListener(ev -> this.saveChanges());
        buttonPanel.add(this.applyButton);
        buttonPanel.add(this.cancelButton);
        ClientUtilities.adjustEqualSizes(this.cancelButton, this.applyButton);
        return buttonPanel;
    }

    private Application getApplication() {
        return this.application;
    }

    private boolean validateProperties() {
        boolean isValid = true;
        StringBuilder invalidFields = new StringBuilder();
        for (int i = 0; i < this.algoTable.getRowCount(); ++i) {
            AlgorithmInfo algoInfo = this.sortedAlgos[i];
            for (int j = 0; j < this.properties.size(); ++j) {
                String value;
                AlgorithmProperty algoProp = this.properties.get(j);
                if (algoProp.isValidValue(value = (String)this.algoTable.getValueAt(i, j + 1))) continue;
                invalidFields.append("\n  - " + algoInfo.getName() + ": " + algoProp.getLabel());
                isValid = false;
            }
        }
        if (!isValid) {
            String dialogTitle = LNG.get((String)"algomanager.title.algo_properties");
            String title = LNG.get((String)"algomanager.title.error") + " - " + dialogTitle;
            StringBuilder msg = new StringBuilder();
            msg.append(LNG.get((String)"algomanager.error.validation.properties.1"));
            msg.append("\n");
            msg.append((CharSequence)invalidFields);
            msg.append("\n\n");
            msg.append(LNG.get((String)"algomanager.error.validation.properties.2"));
            StandardDialogs.showErrorDialog((Component)this, (String)title, (String)msg.toString());
        }
        return isValid;
    }

    private void fireTableRowUpdated() {
        boolean reloaded;
        boolean reloadAlgorithms = false;
        for (int i = 0; i < this.algoTable.getRowCount(); ++i) {
            Hashtable algoProperties = this.sortedAlgos[i].getPropertyValues();
            Hashtable<String, String> newProperties = new Hashtable<String, String>();
            String propKey = null;
            String propValue = null;
            boolean update = false;
            for (int j = 0; j < this.properties.size(); ++j) {
                AlgorithmProperty algoProp = this.properties.get(j);
                String newPropValue = ((String)this.algoTable.getValueAt(i, j + 1)).trim();
                propKey = algoProp.getKey();
                propValue = (String)algoProperties.get(propKey);
                if (newPropValue.length() == 0 && propValue == null) continue;
                if (!newPropValue.equals(propValue)) {
                    update = true;
                }
                newProperties.put(propKey, newPropValue);
            }
            if (!update) continue;
            reloadAlgorithms = true;
            String algoName = this.sortedAlgos[i].getName();
            this.sortedAlgos[i] = AlgorithmManagementProxy.changeAlgorithmProperties(algoName, newProperties, this);
            String dialogTitle = LNG.get((String)"algomanager.title.algo_properties");
            if (this.sortedAlgos[i] != null) continue;
            String title = LNG.get((String)"algomanager.title.error") + " - " + dialogTitle;
            StandardErrorDialogs.showErrorDialog((Window)this, title, MessageFormat.format(LNG.get((String)"algomanager.error.update"), algoName));
        }
        this.askForConfirmation = false;
        if (reloadAlgorithms && (reloaded = AlgorithmManagementProxy.reloadAlgorithms(this))) {
            StandardDialogs.showInfoDialog((Component)this, (String)LNG.get((String)"algorithm.title.reload"), (Object)LNG.get((String)"algorithm.msg.reload"));
        }
    }

    private void saveChanges() {
        if (this.validateProperties()) {
            this.fireTableRowUpdated();
            this.close();
        }
    }

    private void showSaveDialog() {
        int n = NO_OPTION;
        if (this.askForConfirmation) {
            Object[] options = new Object[]{LNG.get((String)"IAS_YES"), LNG.get((String)"IAS_NO")};
            n = JOptionPane.showOptionDialog(this, LNG.get((String)"ias.algorithm.AlgoManagerFrame.question.properties_change"), LNG.get((String)"algomanager.title.properties_change"), 1, 3, null, options, options[0]);
        }
        if (n != YES_OPTION) {
            this.close();
        } else {
            this.saveChanges();
        }
    }

    @Override
    public void wasModified() {
        this.askForConfirmation = true;
    }
}

