/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.AbstractSimpleApplicationPanel;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.AlgorithmOutline;
import csdk.v1_0.helper.application.ApplicationImages;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;

public class AlgorithmStaticInfoPanel
extends AbstractSimpleApplicationPanel<AlgorithmsManager> {
    private JTextField nameText;
    private JTextField idText;

    public AlgorithmStaticInfoPanel(AlgorithmsManager application) {
        super(application);
        this.buildPanel();
    }

    @Override
    protected void buildPanel() {
        this.nameText = new JTextField(30);
        this.nameText.setEditable(false);
        JButton renameButton = new JButton(ApplicationImages.ICON_EDIT_16);
        String renameTooltip = this.getString("AlgorithmStaticInfoPanel.rename.tooltip");
        renameButton.setToolTipText(renameTooltip);
        renameButton.addActionListener(e -> this.openRenameDialog());
        this.idText = new JTextField(30);
        this.idText.setEditable(false);
        this.setLayout(new GridBagLayout());
        String idStr = this.getString("AlgorithmStaticInfoPanel.label.id");
        String nameStr = this.getString("AlgorithmStaticInfoPanel.label.name");
        JLabel idLabel = new JLabel(idStr);
        JLabel nameLabel = new JLabel(nameStr);
        GUIUtils.mountBasicGridPanel((JPanel)this, (JComponent[][])new JComponent[][]{{nameLabel, this.nameText, renameButton}, {idLabel, this.idText, null}});
    }

    private void openRenameDialog() {
        AlgorithmsManager application = (AlgorithmsManager)this.getApplication();
        String nameLabel = this.getString("AlgorithmStaticInfoPanel.rename.label");
        String warningMsg = this.getString("AlgorithmStaticInfoPanel.rename.warning");
        String title = this.getString("AlgorithmStaticInfoPanel.rename.title");
        String currentName = this.nameText.getText();
        String newName = (String)JOptionPane.showInputDialog(this.nameText, warningMsg + "\n\n" + nameLabel, title, 2, null, null, currentName);
        if (newName != null && !(newName = newName.trim()).isEmpty() && !newName.equals(currentName)) {
            if (this.isNameAvailable(newName)) {
                ApplicationFrame frame = application.getApplicationFrame();
                String id = this.idText.getText();
                AlgorithmManagementProxy.renameAlgorithm(id, newName.trim(), frame);
            } else {
                String error = this.getString("AlgorithmStaticInfoPanel.rename.error", new Object[]{newName});
                StandardDialogs.showErrorDialog((Component)this.nameText, (String)title, (String)error);
            }
        }
    }

    private boolean isNameAvailable(String name) {
        AlgorithmOutline[] outlines;
        ApplicationFrame frame = ((AlgorithmsManager)this.getApplication()).getApplicationFrame();
        for (AlgorithmOutline outline : outlines = AlgorithmManagementProxy.getAllAlgorithmOutlines(frame, AlgorithmManagementProxy.AlgorithmOperation.ADMIN_ALGORITHM)) {
            if (!outline.getName().trim().equals(name)) continue;
            return false;
        }
        return true;
    }

    public void setSelectedAlgorithm(AlgorithmListItem algorithm) {
        String name = null;
        String id = null;
        if (algorithm != null) {
            name = algorithm.getName();
            id = algorithm.getId();
        }
        this.nameText.setText(name);
        this.idText.setText(id);
    }
}

