/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.implementations;

import csbase.client.applications.Application;
import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.remote.ClientRemoteLocator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FlowConfiguratorSource
implements Iterable<FlowAlgorithmConfigurator> {
    private List<FlowAlgorithmConfigurator> list = new ArrayList<FlowAlgorithmConfigurator>();

    public FlowConfiguratorSource(Application app) {
        RemoteTask<List<FlowAlgorithmConfigurator>> task = new RemoteTask<List<FlowAlgorithmConfigurator>>(){

            protected void performTask() throws Exception {
                AlgorithmInfo[] infos = ClientRemoteLocator.algorithmService.getAllInfo();
                ArrayList<FlowAlgorithmConfigurator> flows = new ArrayList<FlowAlgorithmConfigurator>();
                int i = 0;
                int n = infos.length;
                for (AlgorithmInfo info : infos) {
                    this.setProgressStatus(i * 100 / n);
                    if (info != null && info.getLastVersion() != null && info.getLastVersion().getType() == AlgorithmConfigurator.ConfiguratorType.FLOW) {
                        try {
                            FlowAlgorithmConfigurator configurator = (FlowAlgorithmConfigurator)ClientRemoteLocator.algorithmService.createAlgorithmConfigurator(info.getName(), info.getLastVersion().getId());
                            flows.add(configurator);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                this.setResult(flows);
            }
        };
        task.execute(app.getApplicationFrame(), app.getClassString(this.getClass(), "task.title"), app.getClassString(this.getClass(), "task.description"), true, false);
        this.list = task.getStatus() ? (List<Object>)task.getResult() : new ArrayList<FlowAlgorithmConfigurator>();
    }

    @Override
    public Iterator<FlowAlgorithmConfigurator> iterator() {
        return this.list.iterator();
    }
}

