/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.implementations;

import csbase.client.applications.algorithmsmanager.report.core.AbstractRemoteTest;
import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.TestStatus;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.Node;
import csbase.remote.ClientRemoteLocator;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public class TestOutdatedFlow
extends AbstractRemoteTest<FlowAlgorithmConfigurator> {
    public TestOutdatedFlow(Window window) {
        super(window, LNG.get((String)"TestOutdatedFlow.task.title"), LNG.get((String)"TestOutdatedFlow.task.message"));
    }

    @Override
    public List<IResultMessage<FlowAlgorithmConfigurator>> doTest(FlowAlgorithmConfigurator configurator) {
        ArrayList<IResultMessage<FlowAlgorithmConfigurator>> list = new ArrayList<IResultMessage<FlowAlgorithmConfigurator>>();
        list.add(this.isOutdated(configurator));
        return list;
    }

    private IResultMessage<FlowAlgorithmConfigurator> isOutdated(FlowAlgorithmConfigurator configurator) {
        try {
            String messageText = "";
            for (Node node : configurator.getNodes()) {
                String name = node.getConfigurator().getAlgorithmName();
                AlgorithmVersionInfo lastVersion = ClientRemoteLocator.algorithmService.getInfo(name).getLastVersion();
                AlgorithmVersionInfo nodeVersion = node.getConfigurator().getAlgorithmVersion();
                if (nodeVersion.equals((Object)lastVersion)) continue;
                messageText = messageText + " |  " + LNG.get((String)"TestOutdatedFlow.can.be.updated", (Object[])new String[]{name, nodeVersion.toString(), lastVersion.toString()});
            }
            if (messageText.length() > 0) {
                messageText = LNG.get((String)"TestOutdatedFlow.outdated") + messageText;
                ResultMessage<FlowAlgorithmConfigurator> message = new ResultMessage<FlowAlgorithmConfigurator>(configurator, TestStatus.ERROR, messageText);
                return message;
            }
            String text = LNG.get((String)"TestoutdateFlow.uptodate");
            ResultMessage<FlowAlgorithmConfigurator> message = new ResultMessage<FlowAlgorithmConfigurator>(configurator, TestStatus.OK, text);
            return message;
        }
        catch (Exception e) {
            String text = e.getMessage();
            ResultMessage<FlowAlgorithmConfigurator> message = new ResultMessage<FlowAlgorithmConfigurator>(configurator, TestStatus.ERROR, text);
            return message;
        }
    }

    @Override
    public String getName() {
        return LNG.get((String)"TestOutdatedFlow.name");
    }

    @Override
    public String getDescription() {
        return LNG.get((String)"TestOutdatedFlow.description");
    }

    @Override
    public Class<FlowAlgorithmConfigurator> getSubjectClass() {
        return FlowAlgorithmConfigurator.class;
    }

    @Override
    public String getSubjectName(FlowAlgorithmConfigurator subject) {
        return subject.getAlgorithmName();
    }
}

