/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.pdfviewer.actions;

import csbase.client.ClientLocalFile;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.pdfviewer.PDFViewer;
import csbase.client.applications.pdfviewer.actions.AbstractOpenPdfFileAction;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.logic.ClientFile;
import java.awt.Component;
import tecgraf.javautils.gui.StandardDialogs;

public class OpenLocalPdfFileAction
extends AbstractOpenPdfFileAction {
    private ClientLocalFile lastDirectory;

    public OpenLocalPdfFileAction(PDFViewer application) {
        super(application, ApplicationImages.ICON_OPEN_LOCAL_16);
    }

    @Override
    protected ClientFile chooseClientFileOrNull() {
        Object application = this.getApplication();
        ApplicationFrame window = ((Application)application).getApplicationFrame();
        String title = ((ApplicationType)application).getName();
        ClientLocalFile clientLocalFile = ClientLocalFileChooserUtil.browseSingleFileInOpenMode(window, this.getProjectFileExtensions(), title, true, this.lastDirectory);
        if (clientLocalFile == null) {
            return null;
        }
        this.lastDirectory = clientLocalFile.getParent();
        if (clientLocalFile.exists()) {
            return clientLocalFile;
        }
        StandardDialogs.showErrorDialog((Component)window, (String)((PDFViewer)this.getApplication()).getString("pdfviewer.open.error.title"), (String)this.getString("OpenLocalPdfFileAction.file.not.found.error", new Object[0]));
        return null;
    }
}

