/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.ReloadSelectedProjectsTask;
import csbase.client.remote.ProjectAdminObserver;
import csbase.logic.CommonProjectInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Observer;

public abstract class AbstractProjectsManagerObserver
implements Observer {
    protected ProjectsManager projectsManager;

    public AbstractProjectsManagerObserver(ProjectsManager projectsManager) {
        this.projectsManager = projectsManager;
        ProjectAdminObserver.getInstance().addObserver(this);
    }

    private ProjectsManagerData gatherProjectInfo(Object projectId, String projectName, Object userId) {
        ProjectsManagerData pmd = new ProjectsManagerData(projectId, projectName, userId);
        ArrayList<ProjectsManagerData> pmds = new ArrayList<ProjectsManagerData>();
        pmds.add(pmd);
        ReloadSelectedProjectsTask rspt = new ReloadSelectedProjectsTask(this.projectsManager, pmds);
        rspt.execute(this.projectsManager.getApplicationFrame(), this.projectsManager.getName(), ProjectsManagerUI.getString("AbstractProjectsManagerObserver.message"));
        if (rspt.wasCancelled()) {
            String err = ProjectsManagerUI.getString("AbstractProjectsManagerObserver.cancelled.message");
            rspt.showError(err);
            return null;
        }
        if (!rspt.getStatus()) {
            Exception exception = rspt.getError();
            ProjectsManagerUI.handleException(this.projectsManager, exception);
            return null;
        }
        List projectData = (List)rspt.getResult();
        if (projectData == null) {
            return null;
        }
        return (ProjectsManagerData)projectData.get(0);
    }

    public void removeItselfAsObserver() {
        ProjectAdminObserver.getInstance().deleteObserver(this);
    }

    protected void addProject(CommonProjectInfo prjInfo) {
        ProjectsManagerData pmd = this.gatherProjectInfo(prjInfo.projectId, prjInfo.name, prjInfo.userId);
        this.projectsManager.addProject(pmd);
    }
}

