/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.StatusDialog;
import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;
import csbase.client.applications.projectsmanager.proxy.AllocateAreaTask;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import tecgraf.javautils.gui.StandardDialogs;

public class AllocateAreaAction
extends ProjectsManagerAction {
    public AllocateAreaAction(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    public void actionDone() throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        List<ProjectsManagerData> projectList = projectsManager.getSelectedProjects();
        if (projectList == null || projectList.size() <= 0) {
            return;
        }
        ApplicationFrame appFrame = projectsManager.getApplicationFrame();
        List<ProjectsManagerData> projects = this.validateProjects(projectList);
        if (projects == null) {
            return;
        }
        boolean ret = this.runTask(projects);
        if (ret) {
            AllocateAreaAction.updateStatusOfLocalProjects(projectList);
            projectsManager.refreshProjectsTable();
        } else {
            String errMsg = this.getString("AllocateAreaAction.error.allocation.message");
            String errTitle = this.getString("AllocateAreaAction.error.allocation.title");
            StandardDialogs.showErrorDialog((Component)appFrame, (String)errTitle, (String)errMsg);
        }
    }

    private static void updateStatusOfLocalProjects(List<ProjectsManagerData> projectList) {
        for (ProjectsManagerData pmd : projectList) {
            pmd.setProjectSpaceAllocation(ProjectSpaceAllocation.ALLOCATED);
            long requestedSpace = pmd.getRequestedSpace();
            pmd.setAllocatedSpace(requestedSpace);
            pmd.setScope(ProjectsManagerScope.PRIVATE);
        }
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return ProjectsManagerUI.ALLOCATE;
    }

    @Override
    protected List<ProjectsManagerData> validateProjects(List<ProjectsManagerData> projectList) {
        String someDeniedMessage;
        int res;
        ArrayList<ProjectsManagerData> prjList = new ArrayList<ProjectsManagerData>();
        prjList.addAll(projectList);
        ArrayList<ProjectsManagerData> failedProjects = new ArrayList<ProjectsManagerData>();
        int i = 0;
        while (i < prjList.size()) {
            ProjectsManagerData pmd = (ProjectsManagerData)prjList.get(i);
            if (pmd.getProjectSpaceAllocation() != ProjectSpaceAllocation.WAITING_ALLOCATION) {
                failedProjects.add(pmd);
                prjList.remove(i);
                continue;
            }
            ++i;
        }
        ProjectsManager projectsManager = this.getProjectsManager();
        if (prjList.size() == 0) {
            String deniedMessage = this.getString("AllocateAreaAction.project.selection.denied.message") + this.getString("AllocateAreaAction.project.requirements.message");
            StatusDialog.showNoneOkDialog(projectsManager, deniedMessage, failedProjects, this.getString("AllocateAreaAction.project.selection.failure.message"));
            return null;
        }
        if (failedProjects.size() > 0 && (res = StatusDialog.showSomeOkDialog(projectsManager, someDeniedMessage = this.getString("AllocateAreaAction.project.selection.some.denied.message") + this.getString("AllocateAreaAction.project.requirements.message"), prjList, this.getString("AllocateAreaAction.project.selection.some.failure.message"))) == 0) {
            return null;
        }
        return prjList;
    }

    private boolean runTask(List<ProjectsManagerData> projects) throws Exception {
        ProjectsManager projectsManager = this.getProjectsManager();
        AllocateAreaTask aat = new AllocateAreaTask(projectsManager, projects, true);
        ApplicationFrame appFrame = projectsManager.getApplicationFrame();
        aat.execute(appFrame, this.getString("AllocateAreaAction.title"), this.getString("AllocateAreaAction.message"));
        if (aat.wasCancelled()) {
            String err = this.getString("AllocateAreaAction.cancelled.message");
            aat.showError(err);
            return false;
        }
        if (!aat.getStatus()) {
            Exception exception = aat.getError();
            throw exception;
        }
        return (Boolean)aat.getResult();
    }
}

