/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels.renderers;

import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TableOccupationRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        JLabel label = (JLabel)component;
        label.setHorizontalAlignment(4);
        if (value != null) {
            double occupation = (Double)value;
            if (occupation == -1.0) {
                label.setText(ProjectsManagerUI.getString("TableOccupationRenderer.not.loaded.message"));
                return label;
            }
            if ((occupation = (double)Math.round(occupation * 1000.0) / 1000.0) < 1.0) {
                label.setText(String.valueOf(occupation *= 1024.0) + " kb");
            } else if (occupation > 1024.0) {
                occupation /= 1024.0;
                occupation = (double)Math.round(occupation * 1000.0) / 1000.0;
                label.setText(String.valueOf(occupation) + " gb");
            } else {
                label.setText(String.valueOf(occupation) + " mb");
            }
        } else {
            label.setText(null);
        }
        return label;
    }
}

