/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.sgamonitor.actions;

import csbase.client.applications.AbstractSimpleApplicationAction;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.sgamonitor.SGAMonitor;
import csbase.client.remote.srvproxies.SGAProxy;
import csbase.logic.SGASet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import tecgraf.javautils.gui.StandardDialogs;

public class StopSGAClusterAction
extends AbstractSimpleApplicationAction<SGAMonitor> {
    public StopSGAClusterAction(SGAMonitor application) {
        super(application, ApplicationImages.ICON_STOP_16);
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        SGAMonitor application = (SGAMonitor)this.getApplication();
        List<SGASet> selectedSGAs = application.getSelectedSGAs();
        if (this.confirmShutdown(selectedSGAs)) {
            for (SGASet sga : selectedSGAs) {
                SGAProxy.shutdownSGA(sga.getName());
                sga.setAlive(false);
            }
        }
        application.refreshTables();
    }

    private boolean confirmShutdown(List<SGASet> selectedSGAs) {
        int opt;
        Object app = this.getApplication();
        ApplicationFrame frame = ((Application)app).getApplicationFrame();
        Object[] options = new Object[]{((Application)app).getString("button.stop"), ((Application)app).getString("button.cancel")};
        String title = ((Application)app).getString("confirm.view.title");
        String question = ((Application)app).getString("question.stop.all");
        if (selectedSGAs.size() == 1) {
            SGASet sga = selectedSGAs.get(0);
            question = String.format(((Application)app).getString("question.stop.one"), sga.getName());
        }
        return (opt = StandardDialogs.showOptionDialog((Component)frame, (String)title, (Object)question, (Object[])options)) == 0;
    }
}

