/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.Client;
import csbase.client.desktop.CloneDesktopAction;
import csbase.client.desktop.RemoteTask;
import csbase.client.externalresources.ExternalResources;
import csbase.client.openbus.OpenBusAccessPoint;
import csbase.exception.CSBaseRuntimeException;
import csbase.logic.openbus.OpenBusLoginToken;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.OpenURLServiceInterface;
import java.net.URL;
import java.util.Locale;
import tecgraf.javautils.core.lng.LNG;

class CloneTask
extends RemoteTask<Void> {
    private final CloneDesktopAction action;

    @Override
    protected void handleError(Exception error) {
        String message = error.getMessage();
        this.action.showErrorMessage(message);
    }

    @Override
    protected void handleServerError(CSBaseRuntimeException cserror) {
        String message = cserror.getMessage();
        this.action.showErrorMessage(message);
    }

    public void performTask() throws Exception {
        OpenBusAccessPoint oap = OpenBusAccessPoint.getInstance();
        oap.init();
        oap.initSession();
        OpenBusLoginToken token = oap.getLoginToken();
        Locale locale = LNG.getLocale();
        OpenURLServiceInterface openURLService = ClientRemoteLocator.openURLService;
        Client client = Client.getInstance();
        String myClientId = client.getClientInstanceId();
        String newClientId = client.generateNewSonId();
        URL url = openURLService.getURL(locale, token, myClientId, newClientId, true);
        ExternalResources extResources = ExternalResources.getInstance();
        extResources.showDocument(url);
    }

    public CloneTask(CloneDesktopAction action) {
        this.action = action;
    }
}

