/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.TransferableNode;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import tecgraf.javautils.core.lng.LNG;

public abstract class AbstractProjectFileTransferHandler
extends TransferHandler {
    private static final DataFlavor[] _flavors = new DataFlavor[]{ProjectFileContainer.PROJECT_FILE_FLAVOR};
    private final Window _ownerWindow;
    private final String _ownerTitle;

    public AbstractProjectFileTransferHandler(Window ownerWindow, String ownerTitle) {
        this._ownerWindow = ownerWindow;
        this._ownerTitle = ownerTitle;
    }

    public boolean hasTransferableInClipboard() {
        TransferInfo info = TransferInfoManager.getTransferInfo();
        return null != info && info instanceof ClipboardTransferInfo;
    }

    public void clearClipboard() {
        if (this.hasTransferableInClipboard()) {
            TransferInfoManager.clear();
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavor) {
        int n = flavor.length;
        for (int i = 0; i < n; ++i) {
            int m = _flavors.length;
            for (int j = 0; j < m; ++j) {
                if (!flavor[i].equals(_flavors[j])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void exportAsDrag(JComponent source, InputEvent event, int action) {
        TransferInfoManager.setTransferInfo(new DragTransferInfo(source));
        super.exportAsDrag(source, event, action);
    }

    @Override
    public void exportToClipboard(JComponent source, Clipboard clip, int action) {
        this.clearClipboard();
        if (clip != null) {
            throw new IllegalArgumentException("Clipboard deve ser vazio.");
        }
        Transferable transferable = this.createTransferable(source);
        if (null != transferable) {
            TransferInfoManager.setTransferInfo(new ClipboardTransferInfo(source, transferable, action));
        }
    }

    @Override
    public Transferable createTransferable(JComponent dragSource) {
        ClientProjectFile[] files = this.getFilesToExport(dragSource);
        if (null == files || 0 == files.length) {
            return null;
        }
        return new TransferableNode(files, _flavors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importData(JComponent destination, Transferable data) {
        boolean imported = false;
        try {
            if (!this.canImport(destination, _flavors)) {
                boolean bl = false;
                return bl;
            }
            TransferInfo info = TransferInfoManager.getTransferInfo();
            if (null == info) {
                boolean bl = false;
                return bl;
            }
            if (TransferInfo.ExportMethod.CLIPBOARD == info.getMethod()) {
                data = ((ClipboardTransferInfo)info).getTransferable();
            }
            if (null == data) {
                boolean bl = false;
                return bl;
            }
            if (!data.isDataFlavorSupported(_flavors[0])) {
                boolean bl = false;
                return bl;
            }
            ClientProjectFile destinationDirectory = this.getDestinationDirectory(destination);
            if (null == destinationDirectory || !destinationDirectory.isDirectory()) {
                boolean bl = false;
                return bl;
            }
            info.setDestinationDirectory(destinationDirectory);
            imported = true;
            if (TransferInfo.ExportMethod.CLIPBOARD == info.getMethod()) {
                this.exportDone(info.getSource(), data, ((ClipboardTransferInfo)info).getAction());
            }
            boolean bl = imported;
            return bl;
        }
        finally {
            if (!imported) {
                TransferInfoManager.clear();
            }
        }
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        ClientProjectFile destinationDirectory;
        int transferAction = this.getSourceActions(source) & action;
        if (transferAction == 0) {
            return;
        }
        TransferInfo info = TransferInfoManager.getTransferInfo();
        if (null == info) {
            return;
        }
        if (TransferInfo.ExportMethod.CLIPBOARD == info.getMethod()) {
            data = ((ClipboardTransferInfo)info).getTransferable();
        }
        if (null == (destinationDirectory = info.getDestinationDirectory())) {
            return;
        }
        if (data.isDataFlavorSupported(_flavors[0])) {
            try {
                ClientProjectFile[] files = (ClientProjectFile[])data.getTransferData(_flavors[0]);
                if (null == files || 0 == files.length) {
                    return;
                }
                switch (transferAction) {
                    case 1: {
                        this.copy(files, destinationDirectory);
                        break;
                    }
                    case 2: {
                        if (this.isMoveValid(files)) {
                            this.move(files, destinationDirectory);
                        }
                        this.clearClipboard();
                    }
                }
            }
            catch (Exception e) {
                this.clearClipboard();
                StandardErrorDialogs.showErrorDialog(this._ownerWindow, this._ownerTitle, LNG.get((String)"AbstractProjectFileTransferHandler.error.export"), e);
            }
        }
    }

    protected abstract ClientProjectFile[] getFilesToExport(JComponent var1);

    protected abstract ClientProjectFile getDestinationDirectory(JComponent var1);

    private boolean isMoveValid(ClientProjectFile[] files) {
        for (ClientProjectFile file : files) {
            if (null != file && null != file.getParent()) continue;
            return false;
        }
        return true;
    }

    private void copy(final ClientProjectFile[] files, final ClientProjectFile dir) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                for (int inx = 0; inx < files.length; ++inx) {
                    files[inx].copy(dir);
                }
            }
        };
        task.execute(this._ownerWindow, this._ownerTitle, LNG.get((String)"PRJ_WAITING_FILE_COPY"));
    }

    private void move(final ClientProjectFile[] files, final ClientProjectFile dir) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                for (int inx = 0; inx < files.length; ++inx) {
                    files[inx].move(dir);
                }
            }
        };
        task.execute(this._ownerWindow, this._ownerTitle, LNG.get((String)"PRJ_WAITING_FILE_MOVE"));
    }

    static class DragTransferInfo
    extends TransferInfo {
        protected DragTransferInfo(JComponent source) {
            super(source, TransferInfo.ExportMethod.DRAG);
        }
    }

    static class ClipboardTransferInfo
    extends TransferInfo {
        private final Transferable _transferable;
        private final int _action;

        public ClipboardTransferInfo(JComponent source, Transferable transferable, int action) {
            super(source, TransferInfo.ExportMethod.CLIPBOARD);
            this._transferable = transferable;
            this._action = action;
        }

        public int getAction() {
            return this._action;
        }

        public Transferable getTransferable() {
            return this._transferable;
        }

        @Override
        public void fireOnLoad() {
            if (2 != this.getAction()) {
                return;
            }
            try {
                ClientProjectFile[] files;
                for (ClientProjectFile file : files = (ClientProjectFile[])this.getTransferable().getTransferData(_flavors[0])) {
                    file.setMoving(true);
                }
            }
            catch (Exception e) {
                StandardErrorDialogs.showErrorDialog(null, "Clipboard", LNG.get((String)"AbstractProjectFileTransferHandler.error.export"), e);
            }
            this.getSource().repaint();
        }

        @Override
        public void fireOnUnload() {
            if (2 != this.getAction()) {
                return;
            }
            try {
                ClientProjectFile[] files;
                for (ClientProjectFile file : files = (ClientProjectFile[])this.getTransferable().getTransferData(_flavors[0])) {
                    file.setMoving(false);
                }
            }
            catch (Exception e) {
                StandardErrorDialogs.showErrorDialog(null, "Clipboard", LNG.get((String)"AbstractProjectFileTransferHandler.error.export"), e);
            }
            this.getSource().repaint();
        }
    }

    static class TransferInfo {
        private final JComponent _source;
        private final ExportMethod _method;
        private ClientProjectFile _destinationDirectory;

        protected TransferInfo(JComponent source, ExportMethod method) {
            this._source = source;
            this._method = method;
        }

        public JComponent getSource() {
            return this._source;
        }

        public ExportMethod getMethod() {
            return this._method;
        }

        public ClientProjectFile getDestinationDirectory() {
            return this._destinationDirectory;
        }

        public void setDestinationDirectory(ClientProjectFile destinationDirectory) {
            this._destinationDirectory = destinationDirectory;
        }

        public void fireOnLoad() {
        }

        public void fireOnUnload() {
        }

        public static enum ExportMethod {
            CLIPBOARD,
            DRAG;

        }
    }

    static class TransferInfoManager {
        private static TransferInfo _info;

        TransferInfoManager() {
        }

        public static synchronized void clear() {
            TransferInfoManager.setTransferInfo(null);
        }

        public static synchronized void setTransferInfo(TransferInfo info) {
            if (null != _info) {
                _info.fireOnUnload();
            }
            _info = info;
            if (null != info) {
                info.fireOnLoad();
            }
        }

        private static void checkAndUnsetFilesMoving() {
            if (null == _info) {
                return;
            }
            if (TransferInfo.ExportMethod.CLIPBOARD != _info.getMethod()) {
                return;
            }
        }

        public static TransferInfo getTransferInfo() {
            return _info;
        }

        static {
            RestartManager.getInstance().addListener(new RestartListener(){

                public void restart() {
                    TransferInfoManager.clear();
                }
            });
        }
    }
}

