/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies;

import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.DesktopTask;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.util.StandardErrorDialogs;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.HttpServiceInterface;
import java.awt.Window;
import tecgraf.javautils.core.lng.LNG;

public class HttpProxy {
    static String failureMessage = LNG.get((String)"HTTP_PROXY_FAILURE");
    static String successMessage = LNG.get((String)"HTTP_PROXY_SUCCESS");
    static String title = LNG.get((String)"HTTP_PROXY_TITLE");
    private static final String DOWNLOAD = "download";
    private static final String UPLOAD = "upload";

    private static void showError(String msg) {
        DesktopFrame dsk = DesktopFrame.getInstance();
        if (dsk == null) {
            return;
        }
        DesktopComponentFrame mainFrame = dsk.getDesktopFrame();
        if (mainFrame == null) {
            return;
        }
        StandardErrorDialogs.showErrorDialog((Window)mainFrame, title, msg);
    }

    public static String getDownloadURL(Object projectId, String[] filePath) {
        return HttpProxy.getURL(projectId, filePath, null, DOWNLOAD);
    }

    public static String getUploadURL(Object projectId, String[] filePath, String fileType) {
        return HttpProxy.getURL(projectId, filePath, fileType, UPLOAD);
    }

    private static String getURL(final Object projectId, final String[] filePath, final String fileType, final String type) {
        DesktopFrame dsk = DesktopFrame.getInstance();
        DesktopComponentFrame mainFrame = dsk.getDesktopFrame();
        if (mainFrame == null) {
            HttpProxy.showError(failureMessage);
            return null;
        }
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                String userId = ClientRemoteMonitor.getInstance().getLogin();
                String password = ClientRemoteMonitor.getInstance().getPassword();
                HttpServiceInterface httpService = ClientRemoteLocator.httpService;
                if (type.equals(HttpProxy.DOWNLOAD)) {
                    this.setResult(httpService.getDownloadURL((Object)userId, password, projectId, filePath));
                } else {
                    this.setResult(httpService.getUploadURL((Object)userId, password, projectId, filePath, fileType));
                }
            }
        };
        task.start(DesktopFrame.getInstance().getDesktopFrame(), title, successMessage);
        Exception exception = task.getException();
        if (exception != null) {
            HttpProxy.showError(exception.getMessage());
            return null;
        }
        String result = (String)task.getResult();
        if (result == null) {
            HttpProxy.showError(LNG.get((String)"HTTP_URL_ERROR"));
        }
        return result;
    }

    public static void setTexts(String proxyTitle, String proxyFailureText, String proxySuccessText) {
        title = proxyTitle;
        failureMessage = proxyFailureText;
        successMessage = proxySuccessText;
    }
}

