/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui;

import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class AlgorithmInfoFilterOperator {
    boolean ignoreCase;
    boolean useRegex;
    boolean showSimple;
    boolean showFlow;
    String text;

    public AlgorithmInfoFilterOperator(boolean ignoreCase, boolean useRegex, boolean showSimple, boolean showFlow, String text) {
        this.ignoreCase = ignoreCase;
        this.useRegex = useRegex;
        this.showSimple = showSimple;
        this.showFlow = showFlow;
        this.text = text;
    }

    public boolean accept(AlgorithmInfo info) {
        String name = info.getName();
        if (name == null) {
            name = "";
        }
        AlgorithmConfigurator.ConfiguratorType type = null;
        AlgorithmVersionInfo version = info.getLastVersion();
        if (version != null) {
            type = version.getType();
        }
        if (type == AlgorithmConfigurator.ConfiguratorType.FLOW && !this.showFlow) {
            return false;
        }
        if (type == AlgorithmConfigurator.ConfiguratorType.SIMPLE && !this.showSimple) {
            return false;
        }
        if (this.text == null || this.text.equals("")) {
            return true;
        }
        if (this.useRegex) {
            try {
                Pattern pattern = Pattern.compile(this.text);
                Matcher matcher = pattern.matcher(name);
                return matcher.find();
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }
        if (this.ignoreCase) {
            name = name.toUpperCase();
            this.text = this.text.toUpperCase();
        }
        return name.contains(this.text);
    }
}

