/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;

class CardsList {
    private LinkedList<Component> cards = new LinkedList();
    private ArrayList<String> cardsNames = new ArrayList();
    private int currentCardindex = -1;

    CardsList() {
    }

    boolean add(String name, Component comp, int index) {
        if (index > this.cards.size() || index < 0) {
            index = this.cards.size();
        }
        if (this.cardsNames.contains(name)) {
            throw new IllegalArgumentException("J\u00e1 existe card com este nome.");
        }
        if (this.cards.contains(comp)) {
            throw new IllegalArgumentException("J\u00e1 existe card com este componente.");
        }
        this.cardsNames.add(index, name);
        this.cards.add(index, comp);
        if (this.currentCardindex == -1) {
            this.currentCardindex = 0;
        }
        return true;
    }

    boolean add(String name, Component comp) {
        return this.add(name, comp, -1);
    }

    String add(Component comp) {
        return this.add(comp, -1);
    }

    String add(Component comp, int index) {
        String name = comp.getClass().getSimpleName() + this.cards.size();
        if (this.add(name, comp, index)) {
            return name;
        }
        return null;
    }

    Component updateCurrentCard(String name) {
        int cardIndex;
        if (!this.cardsNames.contains(name)) {
            return null;
        }
        this.currentCardindex = cardIndex = this.cardsNames.indexOf(name);
        return this.cards.get(cardIndex);
    }

    String getCardName(Component comp) {
        if (!this.cards.contains(comp)) {
            return null;
        }
        int cardIndex = this.cards.indexOf(comp);
        return this.cardsNames.get(cardIndex);
    }

    Component getComponentForCardName(String name) {
        if (!this.cardsNames.contains(name)) {
            return null;
        }
        int cardIndex = this.cardsNames.indexOf(name);
        return this.cards.get(cardIndex);
    }

    Component getCurrentCard() {
        if (this.cards.isEmpty()) {
            return null;
        }
        return this.cards.get(this.currentCardindex);
    }

    boolean remove(String name) {
        if (!this.cardsNames.contains(name)) {
            return false;
        }
        int cardIndex = this.cardsNames.indexOf(name);
        this.cardsNames.remove(cardIndex);
        this.cards.remove(cardIndex);
        this.correctCurrentCardIndex(cardIndex);
        return true;
    }

    boolean remove(Component comp) {
        if (!this.cards.contains(comp)) {
            return false;
        }
        int cardIndex = this.cards.indexOf(comp);
        this.cardsNames.remove(cardIndex);
        this.cards.remove(cardIndex);
        this.correctCurrentCardIndex(cardIndex);
        return true;
    }

    Component getNextCard() {
        if (this.cards.isEmpty()) {
            return null;
        }
        if (this.currentCardindex == this.cards.size() - 1) {
            this.currentCardindex = 0;
            return this.cards.getFirst();
        }
        ListIterator<Component> i = this.cards.listIterator(this.currentCardindex + 1);
        this.currentCardindex = i.nextIndex();
        return i.next();
    }

    Component getPreviousCard() {
        if (this.cards.isEmpty()) {
            return null;
        }
        if (this.currentCardindex == 0) {
            this.currentCardindex = this.cards.size() - 1;
            return this.cards.getLast();
        }
        ListIterator<Component> i = this.cards.listIterator(this.currentCardindex);
        this.currentCardindex = i.previousIndex();
        return i.previous();
    }

    Component getFirstCard() {
        if (this.cards.isEmpty()) {
            return null;
        }
        this.currentCardindex = 0;
        return this.cards.getFirst();
    }

    Component getLastCard() {
        if (this.cards.isEmpty()) {
            return null;
        }
        this.currentCardindex = this.cards.size() - 1;
        return this.cards.getLast();
    }

    private void correctCurrentCardIndex(int removedCardIndex) {
        if (this.cards.isEmpty()) {
            this.currentCardindex = -1;
            return;
        }
        if (this.currentCardindex > removedCardIndex) {
            --this.currentCardindex;
            return;
        }
        if (this.currentCardindex == this.cards.size()) {
            this.currentCardindex = 0;
            return;
        }
    }
}

