/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v1_0.application;

import csbase.client.applicationmanager.ApplicationType;
import csbase.client.csdk.v1_0.core.CSDKAbstractContext;
import csbase.logic.applicationservice.ApplicationRegistry;
import csdk.v1_0.api.application.IApplication;
import csdk.v1_0.api.application.IApplicationContext;
import java.util.List;
import javax.swing.ImageIcon;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;

public class CSDKApplicationContext
extends CSDKAbstractContext
implements IApplicationContext {
    private ApplicationRegistry registry;
    private final String instanceId;
    private Class<? extends IApplication> mainClass;

    public CSDKApplicationContext(String instanceId, Class<? extends IApplication> mainClass, ApplicationRegistry registry) {
        this.instanceId = instanceId;
        this.mainClass = mainClass;
        this.registry = registry;
    }

    public boolean hasString(String key) {
        return this.registry.hasString(key);
    }

    public String getString(String key, Object ... objs) {
        if (!this.isBundleRequired()) {
            String err = "Aplica\u00e7\u00e3o n\u00e3o est\u00e1 configurada para carregar arquivos de idioma";
            throw new IllegalStateException(err);
        }
        return this.registry.getString(key, objs);
    }

    public String getApplicationId() {
        return this.registry.getId();
    }

    public boolean isPropertyNull(String propName) {
        return this.registry.isPropertyNull(propName);
    }

    public boolean isBundleRequired() {
        return this.registry.isBundleRequired();
    }

    public String getProperty(String propName) {
        return this.registry.getStringSpecificProperty(propName);
    }

    public String getApplicationName() {
        return this.registry.getApplicationName(LNG.getLocale());
    }

    public ImageIcon getImageIcon(String[] path) {
        String imagePath = FileUtils.joinPath((char)'/', (String[])path);
        return ApplicationType.getImageIcon(this.mainClass, imagePath);
    }

    public ImageIcon getApplicationIcon() {
        byte[] imageDefinition = this.registry.getImageDefinition();
        if (imageDefinition != null) {
            return new ImageIcon(imageDefinition);
        }
        return null;
    }

    public ImageIcon getSmallApplicationIcon() {
        byte[] iconDefinition = this.registry.getIconDefinition();
        if (iconDefinition != null) {
            return new ImageIcon(iconDefinition);
        }
        return null;
    }

    public String[] getApplicationFileTypes() {
        List fileTypes = this.registry.getFileTypes();
        if (fileTypes == null) {
            return new String[0];
        }
        return fileTypes.toArray(new String[fileTypes.size()]);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getVersion() {
        return this.registry.getVersion();
    }

    public String getApplicationDescription() {
        return this.registry.getApplicationDescription(LNG.getLocale());
    }

    public String getAuthor() {
        return this.registry.getAuthorName();
    }

    public String getAuthorEmail() {
        return this.registry.getAuthorMail();
    }

    public boolean isSingleton() {
        return this.registry.isSingleton();
    }

    public boolean requiresProject() {
        return this.registry.requireProject();
    }

    @Override
    protected void contextDeactivated() {
        this.registry = null;
        this.mainClass = null;
    }
}

