/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.configurabletable.UI;

import csbase.client.facilities.configurabletable.UI.ORIENTATION;
import csbase.client.facilities.configurabletable.UI.Panel4Tables;
import csbase.client.facilities.configurabletable.UI.UI4Tables;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JSplitPane;

public class SplitPane4Tables
extends JSplitPane
implements UI4Tables {
    private String id;
    private List<Panel4Tables> panels;

    public SplitPane4Tables(String id, ORIENTATION orientation) {
        super(SplitPane4Tables.convertOrientation(orientation));
        if (id == null) {
            throw new IllegalArgumentException("id n\u00e3o pode ser nulo.");
        }
        if (orientation == null) {
            throw new IllegalArgumentException("orientation n\u00e3o pode ser nulo.");
        }
        this.id = id;
        this.panels = new ArrayList<Panel4Tables>();
    }

    static int convertOrientation(ORIENTATION orientation) {
        int orientationInt = 0;
        if (orientation == ORIENTATION.horizontal || orientation == ORIENTATION.Horizontal || orientation == ORIENTATION.HORIZONTAL) {
            orientationInt = 1;
        }
        return orientationInt;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public <T> void addTable(ConfigurableTable<?> table, String label, Class<T> dataType) {
        if (this.panels.size() == 2) {
            throw new RuntimeException("SplitPane4Tables s\u00f3 permite 2 tabelas.");
        }
        Panel4Tables panel = new Panel4Tables(this.getId(), ORIENTATION.horizontal);
        panel.addTable(table, label, dataType);
        this.panels.add(panel);
    }

    @Override
    public List<ConfigurableTable<?>> getAllTables() {
        ArrayList allTables = new ArrayList();
        for (Panel4Tables panel : this.panels) {
            allTables.addAll(panel.getAllTables());
        }
        return allTables;
    }

    @Override
    public <T> List<ConfigurableTable<T>> getAllTables(Class<T> dataType) {
        ArrayList<ConfigurableTable<T>> allTables = new ArrayList<ConfigurableTable<T>>();
        for (Panel4Tables panel : this.panels) {
            allTables.addAll(panel.getAllTables(dataType));
        }
        return allTables;
    }

    @Override
    public ConfigurableTable<?> getTableById(String tableId) {
        for (Panel4Tables panel : this.panels) {
            ConfigurableTable<?> table = panel.getTableById(tableId);
            if (table == null) continue;
            return table;
        }
        return null;
    }

    @Override
    public <T> ConfigurableTable<T> getTableById(String tableId, Class<T> dataType) {
        for (Panel4Tables panel : this.panels) {
            ConfigurableTable<T> table = panel.getTableById(tableId, dataType);
            if (table == null) continue;
            return table;
        }
        return null;
    }

    @Override
    public List<ConfigurableTable<?>> getTablesFromSelectedComponent() {
        return this.getAllTables();
    }

    @Override
    public <T> List<ConfigurableTable<T>> getTablesFromSelectedComponent(Class<T> dataType) {
        return this.getAllTables(dataType);
    }

    @Override
    public String getTableLabel(String tableId) {
        for (Panel4Tables panel : this.panels) {
            String result = panel.getTableLabel(tableId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void buildUI() {
        this.setOneTouchExpandable(true);
        if (this.panels.size() != 2) {
            throw new RuntimeException("SplitPane4Tables s\u00f3 permite 2 tabelas.");
        }
        for (Panel4Tables panel : this.panels) {
            panel.buildUI();
            this.add(panel);
        }
    }
}

