/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences.editors;

import csbase.client.ClientLocalFile;
import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;
import csbase.client.util.csvpanel.columns.ClientFileChooserTextPanel;
import csbase.client.util.csvpanel.columns.FileChooserListener;
import csbase.client.util.filechooser.ClientFileChooserSelectionMode;
import csbase.client.util.filechooser.ClientFileChooserType;
import csbase.logic.ClientFile;
import java.io.File;
import javax.swing.JComponent;

public class LocalDirectoryEditor
extends PreferenceEditor<String> {
    public LocalDirectoryEditor(PreferenceValue<String> pv) {
        super(pv);
    }

    @Override
    protected JComponent createComponent() {
        String value = (String)this.getValue();
        ClientLocalFile clientFile = null;
        if (value != null && !value.trim().isEmpty()) {
            File file = new File(value);
            clientFile = new ClientLocalFile(file);
        }
        ClientFileChooserType chooserType = ClientFileChooserType.OPEN;
        ClientFileChooserSelectionMode selectionMode = ClientFileChooserSelectionMode.DIRECTORIES_ONLY;
        ClientFileChooserTextPanel.ClientFileLocation location = ClientFileChooserTextPanel.ClientFileLocation.LOCAL_ONLY;
        ClientFileChooserTextPanel panel = new ClientFileChooserTextPanel(clientFile, null, null, chooserType, selectionMode, location);
        panel.setEnabled(this.isEditable());
        panel.addFileSelectionListener(new FileChooserListener(){

            @Override
            public void fileSelected(ClientFile selectedFile) {
                String filePath = selectedFile.getStringPath();
                LocalDirectoryEditor.this.setValue(filePath);
                LocalDirectoryEditor.this.notifyListeners();
            }
        });
        this.setTitledBorder(panel);
        return panel;
    }
}

