/*
 * Decompiled with CFR 0.152.
 */
package csbase.client;

import csbase.client.Client;
import csbase.exception.ConfigurationException;
import csbase.logic.ServerURI;
import csbase.util.edt.TimedEventQueue;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.gui.StandardDialogs;

public final class ClientLauncher {
    private static final int ERROR_STATUS = 1;
    private static final String WHITESPACE_REGEX = "\\s";
    private static final String SYSTEM_NAME_PROPERTY = "system.name";
    private static final String CLIENT_CLASS_PROPERTY = "client.class";
    private static final String DEFAULT_SYSTEM_NAME = "CSBase";
    private static final String EXTENSION_PREFIX_PARAMETER = "extension_prefix";

    public static void main(String[] args) {
        String serverUrl;
        String logRoot;
        Map<String, String> parameterMap = ClientLauncher.createParameterMap(args);
        Level level = Level.OFF;
        String logLevel = parameterMap.get("log_level");
        if (logLevel != null) {
            try {
                level = Level.parse(logLevel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logRoot = (logRoot = parameterMap.get("log_root")) == null ? "csbase.client" : "csbase.client." + logRoot.trim();
        Logger rootLogger = Logger.getLogger(logRoot.trim());
        rootLogger.setLevel(level);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(level);
        rootLogger.addHandler(handler);
        String edtLog = parameterMap.get("log_edt");
        if (Boolean.parseBoolean(edtLog)) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().push((EventQueue)new TimedEventQueue());
        }
        if ((serverUrl = parameterMap.get("server_url")) == null) {
            StandardDialogs.showErrorDialog(null, (String)"Erro ao executar o sistema", (String)MessageFormat.format("O argumento {0} n\u00e3o foi encontrado.", "server_url"));
            System.exit(1);
        }
        if (!ServerURI.isValid((String)serverUrl)) {
            StandardDialogs.showErrorDialog(null, (String)"Erro ao executar o sistema", (String)MessageFormat.format("A URI {0} n\u00e3o \u00e9 v\u00e1lida", serverUrl));
            System.exit(1);
        }
        System.out.println("Servidor: " + serverUrl);
        String extensionPrefix = parameterMap.get(EXTENSION_PREFIX_PARAMETER);
        if (extensionPrefix == null) {
            ConfigurationManager.createInstance();
        } else {
            ConfigurationManager.createInstance((String)extensionPrefix);
        }
        Configuration configuration = null;
        try {
            configuration = ConfigurationManager.getInstance().getConfiguration(ClientLauncher.class);
        }
        catch (ConfigurationManagerException e) {
            e.printStackTrace();
            StandardDialogs.showErrorDialog(null, null, (String)"Falha na instala\u00e7\u00e3o do sistema. Por favor, entre em contato com o administrador.");
            System.exit(1);
            return;
        }
        ClientLauncher.configureNetworkAccess(configuration);
        String systemName = configuration.getOptionalProperty(SYSTEM_NAME_PROPERTY, DEFAULT_SYSTEM_NAME);
        try {
            Client client = ClientLauncher.createClient(systemName, parameterMap);
            if (!client.execute()) {
                System.exit(1);
            }
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            StandardDialogs.showErrorDialog(null, (String)systemName, (String)"Falha na instala\u00e7\u00e3o do sistema. Por favor, entre em contato com o administrador.");
            System.exit(1);
        }
    }

    private static void configureNetworkAccess(Configuration configuration) {
        Boolean bypassProxy = configuration.getOptionalBooleanProperty("client.bypassProxy", false);
        if (bypassProxy.booleanValue()) {
            System.out.println("Habilitando conex\u00e3o direta ao servidor (bypass do proxy).");
            try {
                ProxySelector.setDefault(new ProxySelector(){
                    private final List<Proxy> proxyList = Arrays.asList(Proxy.NO_PROXY);

                    @Override
                    public List<Proxy> select(URI uri) {
                        return this.proxyList;
                    }

                    @Override
                    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                        System.err.println("*** Erro de conex\u00e3o direta (NO_PROXY)");
                        System.err.println("*** URI: " + uri);
                        System.err.println("*** SocketAddress: " + sa);
                        ioe.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                System.err.println("*** Erro ao habilitar bypass do proxy");
                e.printStackTrace();
            }
        }
    }

    private static Client createClient(String systemName, Map<String, String> parameterMap) {
        Constructor clientConstructor;
        Class clientClass;
        Configuration configuration;
        try {
            configuration = ConfigurationManager.getInstance().getConfiguration(ClientLauncher.class);
        }
        catch (ConfigurationManagerException e) {
            throw new ConfigurationException((Throwable)e);
        }
        try {
            clientClass = configuration.getOptionalClassProperty(CLIENT_CLASS_PROPERTY, Client.class);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException((Throwable)e);
        }
        try {
            clientConstructor = clientClass.getDeclaredConstructor(String.class, Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException((Throwable)e, MessageFormat.format("O construtor da classe do cliente {0} n\u00e3o existe.", clientClass));
        }
        try {
            return (Client)clientConstructor.newInstance(systemName, parameterMap);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException((Throwable)e, MessageFormat.format("Erro ao criar o cliente {0}.", clientClass));
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException((Throwable)e, MessageFormat.format("Erro ao criar o cliente {0}.", clientClass));
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException((Throwable)e, MessageFormat.format("Erro ao criar o cliente {0}.", clientClass));
        }
    }

    private static Map<String, String> createParameterMap(String[] parameters) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (int i = 0; i < parameters.length; ++i) {
            String[] parameter = parameters[i].trim().split(WHITESPACE_REGEX);
            if (parameter.length != 2) {
                throw new IllegalArgumentException(MessageFormat.format("O argumento {0} est\u00e1 inv\u00e1lido.", parameters[i]));
            }
            System.out.println(parameter[0].substring(2) + "   " + parameter[1]);
            parameterMap.put(parameter[0].substring(2), parameter[1]);
        }
        return parameterMap;
    }
}

