/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms;

import csbase.client.algorithms.FileViewerDialog;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.Task;
import csbase.logic.FileInfo;
import csbase.logic.RemoteFileInputStream;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import javax.swing.AbstractAction;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.lng.LNG;

public class AlgorithmReleaseNotesAction
extends AbstractAction {
    private AlgorithmVersionInfo versionInfo;
    private AlgorithmInfo algorithmInfo;
    private final Window window;

    public AlgorithmReleaseNotesAction(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("O par\u00e2metro window est\u00e1 nulo.");
        }
        this.window = window;
        this.showName();
        this.showIcon();
        this.putValue("ShortDescription", LNG.get((String)"algorithms.full_description"));
        this.setEnabled(false);
    }

    public AlgorithmReleaseNotesAction(Window window, AlgorithmVersionInfo versionInfo, AlgorithmInfo algorithmInfo) {
        this(window);
        if (versionInfo == null) {
            throw new IllegalArgumentException("O par\u00e2metro versionInfo est\u00e1 nulo.");
        }
        this.setAlgorithmVersionInfo(versionInfo, algorithmInfo);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (this.versionInfo == null) {
            throw new IllegalStateException("N\u00e3o existe vers\u00e3o corrente, ou seja, o atributo versionInfo est\u00e1 nulo.\nUse setAlgorithmVersionInfo ou o construtor que recebe algorithmVersionInfo.");
        }
        FileInfo releaseNotes = this.versionInfo.getReleaseNotes();
        this.showReleaseNotesDialog(releaseNotes.getPath());
    }

    private void showReleaseNotesDialog(String simplePath) {
        RemoteFileInputStream fileInputStream = null;
        try {
            fileInputStream = this.getStreamForReleaseNotes(this.versionInfo.getReleaseNotes().getPath());
            String title = LNG.get((String)"AlgorithmReleaseNotesAction.dialog.title", (Object[])new Object[]{this.algorithmInfo.getName(), this.versionInfo.toString()});
            FileViewerDialog existingDialog = new FileViewerDialog(this.window, title, (InputStream)fileInputStream);
            existingDialog.setVisible(true);
            existingDialog.toFront();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hideIcon() {
        this.putValue("SmallIcon", null);
    }

    public void hideName() {
        this.putValue("Name", null);
    }

    public void setAlgorithmVersionInfo(AlgorithmVersionInfo versionInfo, AlgorithmInfo algorithmInfo) {
        this.versionInfo = versionInfo;
        this.algorithmInfo = algorithmInfo;
        if (this.versionInfo == null) {
            this.setEnabled(false);
            return;
        }
        FileInfo releaseNotes = this.versionInfo.getReleaseNotes();
        if (!this.containsReleaseNotes(releaseNotes)) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    private boolean containsReleaseNotes(FileInfo releaseNotes) {
        return releaseNotes != null && this.isResourceReleaseNotes(releaseNotes.getName());
    }

    private boolean isResourceReleaseNotes(String filePath) {
        return filePath.endsWith("releasenotes.txt");
    }

    private RemoteFileInputStream getStreamForReleaseNotes(final String filePath) throws Exception {
        final AlgorithmServiceInterface service = ClientRemoteLocator.algorithmService;
        Task<RemoteFileInputStream> task = new Task<RemoteFileInputStream>(){

            protected void performTask() throws Exception {
                RemoteFileChannelInfo channel = service.prepareDownloadNotesFile((Object)AlgorithmReleaseNotesAction.this.versionInfo.getInfo().getId(), (Object)AlgorithmReleaseNotesAction.this.versionInfo.getId(), filePath);
                RemoteFileInputStream stream = new RemoteFileInputStream(channel);
                this.setResult(stream);
            }
        };
        task.execute(this.getWindow(), null, filePath);
        Exception error = task.getError();
        if (error != null) {
            throw error;
        }
        if (task.wasCancelled()) {
            return null;
        }
        return (RemoteFileInputStream)task.getResult();
    }

    public void showIcon() {
        this.putValue("SmallIcon", ApplicationImages.ICON_NOTES_24);
    }

    public void showName() {
        this.putValue("Name", LNG.get((String)"algorithms.notes"));
    }

    private Window getWindow() {
        return this.window;
    }
}

