/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.newview;

import csbase.client.algorithms.commands.newview.LogTabConfiguration;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;

class MatchLogTabConfigurationsTask
extends RemoteTask<Map<LogTabConfiguration, Set<ClientProjectFile>>> {
    protected String[] logsDir;
    private List<LogTabConfiguration> configuration;

    public MatchLogTabConfigurationsTask(String[] logsDir, List<LogTabConfiguration> configuration) {
        if (logsDir == null) {
            throw new IllegalArgumentException("O par\u00e2metro logsDir est\u00e1 nulo.");
        }
        this.logsDir = logsDir;
        this.configuration = configuration;
    }

    protected void performTask() throws IOException, ConfigurationManagerException {
        this.setResult(this.matchFilesToConfiguration());
    }

    private Map<LogTabConfiguration, Set<ClientProjectFile>> matchFilesToConfiguration() throws ConfigurationManagerException, RemoteException {
        DesktopFrame desktop = DesktopFrame.getInstance();
        CommonClientProject project = desktop.getProject();
        if (project == null) {
            return Collections.emptyMap();
        }
        ClientProjectFile logsBaseDir = project.getFile(this.logsDir);
        if (logsBaseDir == null) {
            return Collections.emptyMap();
        }
        ClientProjectFile[] children = logsBaseDir.getChildren();
        if (children == null) {
            return Collections.emptyMap();
        }
        HashMap<LogTabConfiguration, Set<ClientProjectFile>> configurations = new HashMap<LogTabConfiguration, Set<ClientProjectFile>>();
        for (LogTabConfiguration cnf : this.configuration) {
            Set<ClientProjectFile> matchingFiles = this.findLogFiles(children, cnf.getFilePatterns());
            configurations.put(cnf, matchingFiles);
        }
        return configurations;
    }

    private Set<ClientProjectFile> findLogFiles(ClientProjectFile[] files, List<String> patterns) throws RemoteException {
        TreeSet<ClientProjectFile> logFiles = new TreeSet<ClientProjectFile>();
        for (ClientProjectFile file : files) {
            if (file.isDirectory()) {
                Set<ClientProjectFile> matchedFilesInDir = this.findLogFiles(file.getChildren(), patterns);
                logFiles.addAll(matchedFilesInDir);
                continue;
            }
            if (!this.matchesPatterns(file, patterns)) continue;
            logFiles.add(file);
        }
        return logFiles;
    }

    private boolean matchesPatterns(ClientProjectFile file, List<String> logFilePatterns) {
        if (logFilePatterns != null) {
            for (String pattern : logFilePatterns) {
                if (!file.getName().matches(pattern.trim())) continue;
                return true;
            }
        }
        return false;
    }
}

