/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.view;

import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.LocalTask;
import csbase.client.util.StandardErrorDialogs;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JTextArea;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

class ExportAction
extends AbstractAction {
    private final JTextArea textArea;
    private JFileChooser exportationFileChooser;

    public ExportAction(JTextArea textArea) {
        super(null, ApplicationImages.ICON_EXPORT_16);
        this.putValue("ShortDescription", LNG.get((String)"FlowAlgorithmCommandView.tab.log.button.export.tooltip"));
        this.textArea = textArea;
        this.exportationFileChooser = this.createCustomChooser();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String message;
        String title;
        final File localFile = this.getLocalFile();
        if (localFile == null) {
            return;
        }
        LocalTask<Void> task = new LocalTask<Void>(){

            protected void performTask() throws Exception {
                ExportAction.this.exportAsStream(localFile, ExportAction.this.textArea);
            }
        };
        DesktopComponentFrame window = DesktopFrame.getInstance().getDesktopFrame();
        boolean result = task.execute(window, title = LNG.get((String)"FlowAlgorithmCommandView.tab.log.button.export.title"), message = LNG.get((String)"FlowAlgorithmCommandView.tab.log.button.export.log"));
        if (result) {
            message = LNG.get((String)"FlowAlgorithmCommandView.tab.log.button.export.log.success", (Object[])new Object[]{localFile.getAbsolutePath()});
            StandardDialogs.showInfoDialog((Component)window, (String)title, (Object)message);
        } else {
            StandardErrorDialogs.showErrorDialog((Window)window, title, (Throwable)task.getError());
        }
    }

    private File getLocalFile() {
        int ret = this.exportationFileChooser.showDialog(this.textArea.getParent(), LNG.get((String)"FlowAlgorithmCommandView.tab.log.button.export.chooser.approve.button"));
        if (ret == 1) {
            return null;
        }
        File localFile = this.exportationFileChooser.getSelectedFile();
        if (localFile.isDirectory()) {
            String nameLocalFile = localFile.getAbsolutePath() + "/out.log";
            localFile = new File(nameLocalFile);
        }
        if (localFile.exists()) {
            String title = LNG.get((String)"FlowAlgorithmCommandView.tab.log.button.export.title");
            Object[] args = new String[]{localFile.getName(), localFile.getParentFile().getAbsolutePath()};
            String msg = LNG.get((String)"FlowAlgorithmCommandView.tab.log.button.export.overwrite.msg", (Object[])args);
            int option = StandardDialogs.showYesNoDialog((Component)this.textArea, (String)title, (Object)msg);
            if (option == 1) {
                return null;
            }
        }
        this.exportationFileChooser.setCurrentDirectory(localFile);
        return localFile;
    }

    private void exportAsStream(File localFile, JTextArea textArea) throws Exception {
        int bufferSize = 49152;
        String consolidatedLog = textArea.getText();
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(consolidatedLog.getBytes()));
        FileOutputStream fileStream = new FileOutputStream(localFile);
        BufferedOutputStream out = new BufferedOutputStream(fileStream);
        byte[] buffer = new byte[49152];
        int len = 0;
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        out.flush();
        out.close();
        in.close();
    }

    private JFileChooser createCustomChooser() {
        this.exportationFileChooser = new JFileChooser();
        this.exportationFileChooser.setMultiSelectionEnabled(false);
        this.exportationFileChooser.setApproveButtonText(LNG.get((String)"FlowAlgorithmCommandView.tab.log.button.export.chooser.approve.button"));
        this.exportationFileChooser.setApproveButtonToolTipText(LNG.get((String)"FlowAlgorithmCommandView.tab.log.button.export.chooser.approve.button.tooltip"));
        this.exportationFileChooser.setDialogTitle(LNG.get((String)"FlowAlgorithmCommandView.tab.log.button.export.chooser.title"));
        this.exportationFileChooser.setFileSelectionMode(2);
        return this.exportationFileChooser;
    }
}

