/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager;

import csbase.client.applicationmanager.CSDKCacheLocation;
import csbase.client.preferences.PreferenceEditor;
import csbase.client.preferences.PreferenceValue;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;

public class CSDKCacheLocationPreferenceEditor
extends PreferenceEditor<String> {
    public CSDKCacheLocationPreferenceEditor(PreferenceValue<String> pv) {
        super(pv);
    }

    @Override
    protected JComponent createComponent() {
        CSDKCacheLocation location;
        final JComboBox<CSDKCacheLocation> comboBox = new JComboBox<CSDKCacheLocation>(CSDKCacheLocation.values());
        try {
            location = CSDKCacheLocation.valueOf((String)this.getValue());
        }
        catch (Exception e) {
            location = null;
        }
        if (location != null) {
            comboBox.setSelectedItem((Object)location);
        } else {
            comboBox.setSelectedIndex(-1);
        }
        comboBox.setRenderer(new CSDKCacheLocationRenderer());
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CSDKCacheLocation cacheLocation = (CSDKCacheLocation)((Object)comboBox.getSelectedItem());
                if (cacheLocation == null) {
                    CSDKCacheLocationPreferenceEditor.this.setValue(null);
                } else {
                    CSDKCacheLocationPreferenceEditor.this.setValue(cacheLocation.name());
                }
                CSDKCacheLocationPreferenceEditor.this.notifyListeners();
            }
        });
        comboBox.setEnabled(this.isEditable());
        return comboBox;
    }

    class CSDKCacheLocationRenderer
    extends DefaultListCellRenderer {
        CSDKCacheLocationRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                CSDKCacheLocation location = (CSDKCacheLocation)((Object)value);
                label.setText(location.getDescription());
            }
            return label;
        }
    }
}

