/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import csbase.client.Client;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import tecgraf.javautils.core.timestamp.TStamp32;

public class ExternalApplicationManager {
    private static final ExecutorService threadPool = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private Map<String, String> applications = new HashMap<String, String>();
    private static final String USER_AGENT = "CSBase REST Client";

    private static String sendPost(String url, String data) {
        try {
            String inputLine;
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("User-Agent", "CSBase REST Client " + Client.getInstance().getVersion());
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("Accept", "application/json");
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(data);
            wr.flush();
            wr.close();
            int responseCode = con.getResponseCode();
            System.out.println("\nSending 'POST' request to URL: " + url);
            System.out.println("Post data: " + data);
            System.out.println("Response Code: " + responseCode);
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            System.out.println("Response Data:\n" + response.toString());
            return response.toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String registerApplication(String url, String type) {
        TStamp32 idSuffix = new TStamp32();
        String id = type + "_" + idSuffix;
        this.applications.put(id, url);
        return id;
    }

    public boolean unregisterApplication(String id) {
        String removed = this.applications.remove(id);
        return removed != null;
    }

    public boolean hasId(String id) {
        return this.applications.containsKey(id);
    }

    public void broadcastMessage(String type, Object value, String senderId) {
        if (senderId == null) {
            throw new IllegalArgumentException("senderID can't be null");
        }
        this.applications.keySet().stream().filter(key -> !key.equals(senderId)).forEach(key -> this.sendAsyncMessage((String)key, type, value, senderId));
    }

    public void sendAsyncMessage(String appInstanceId, String type, Object value, String senderId) {
        String url = this.applications.get(appInstanceId);
        if (url == null) {
            throw new IllegalArgumentException("instance ID not registered");
        }
        try {
            RequestMessage message = new RequestMessage(type, senderId, value);
            String data = objectMapper.writeValueAsString((Object)message);
            threadPool.submit(() -> ExternalApplicationManager.sendPost(url, data));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    public Object sendSyncMessage(String appInstanceId, String type, Object value, String senderId) {
        String url = this.applications.get(appInstanceId);
        if (url == null) {
            throw new IllegalArgumentException("instance ID not registered");
        }
        try {
            RequestMessage message = new RequestMessage(type, senderId, value);
            String data = objectMapper.writeValueAsString((Object)message);
            String response = ExternalApplicationManager.sendPost(url, data);
            HashMap map = (HashMap)objectMapper.readValue(response, HashMap.class);
            return map;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private class RequestMessage {
        private String type;
        private String senderId;
        private Object value;

        public RequestMessage(String type, String senderId, Object value) {
            this.type = type;
            this.senderId = senderId;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getSenderId() {
            return this.senderId;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

