/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient.actions;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferProxy;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.queuepanel.FileTransferClientQueuePanel;
import csbase.logic.User;
import csbase.logic.filetransferservice.FileTransferConnection;
import csbase.logic.filetransferservice.FileTransferRequest;
import csbase.logic.filetransferservice.FileTransferRequestStatus;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ClearEndedAction
extends FileTransferClientAction {
    private boolean isEndedRequest(FileTransferRequest request) {
        FileTransferRequestStatus status = request.getStatus();
        if (status == FileTransferRequestStatus.ERROR) {
            return true;
        }
        if (status == FileTransferRequestStatus.FINISHED) {
            return true;
        }
        return status == FileTransferRequestStatus.INTERRUPTED;
    }

    @Override
    public void actionDone(JComponent component) {
        FileTransferClient application = (FileTransferClient)this.getApplication();
        FileTransferClientQueuePanel queuePanel = application.getQueuePanel();
        List<FileTransferRequest> reqs = queuePanel.getAllRequests();
        User loggedUser = User.getLoggedUser();
        Object loggedId = loggedUser.getId();
        ArrayList<String> ids = new ArrayList<String>();
        for (FileTransferRequest req : reqs) {
            FileTransferConnection connection = req.getConnection();
            Object userId = connection.getUserId();
            if (!userId.equals(loggedId) || !this.isEndedRequest(req)) continue;
            ids.add(req.getId());
        }
        FileTransferProxy proxy = application.getServiceProxy();
        proxy.removeRequests(ids);
        queuePanel.refresh();
    }

    @Override
    public ImageIcon getStandardImageIcon() {
        return null;
    }

    public ClearEndedAction(FileTransferClient application) {
        super(application);
    }
}

